/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.config;

import com.google.common.net.InetAddresses;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.iotdb.cluster.config.ClusterConfig;
import org.apache.iotdb.cluster.config.ConsistencyLevel;
import org.apache.iotdb.cluster.exception.BadSeedUrlFormatException;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterDescriptor {
    private static final Logger logger = LoggerFactory.getLogger(ClusterDescriptor.class);
    private static final ClusterDescriptor INSTANCE = new ClusterDescriptor();
    private final ClusterConfig config = new ClusterConfig();

    private ClusterDescriptor() {
        this.loadProps();
        if (this.config.isOpenServerRpcPort()) {
            IoTDBDescriptor.getInstance().getConfig().setEnableRpcService(true);
            IoTDBDescriptor.getInstance().getConfig().setRpcPort(IoTDBDescriptor.getInstance().getConfig().getRpcPort() + 1);
        } else {
            IoTDBDescriptor.getInstance().getConfig().setEnableRpcService(false);
        }
    }

    public ClusterConfig getConfig() {
        return this.config;
    }

    public static ClusterDescriptor getInstance() {
        return INSTANCE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getPropsUrl() {
        String url = System.getProperty("IOTDB_CONF", null);
        if (url != null) return url + File.separatorChar + "iotdb-cluster.properties";
        url = System.getProperty("IOTDB_HOME", null);
        if (url != null) {
            return url + File.separatorChar + "conf" + File.separatorChar + "iotdb-cluster.properties";
        }
        logger.warn("Cannot find IOTDB_HOME or IOTDB_CONF environment variable when loading config file {}, use default configuration", (Object)"iotdb-cluster.properties");
        return null;
    }

    public void replaceHostnameWithIp() throws UnknownHostException, BadSeedUrlFormatException {
        boolean isInvalidClusterInternalIp = InetAddresses.isInetAddress((String)this.config.getInternalIp());
        if (!isInvalidClusterInternalIp) {
            this.config.setInternalIp(this.hostnameToIP(this.config.getInternalIp()));
        }
        ArrayList<String> newSeedUrls = new ArrayList<String>();
        for (String seedUrl : this.config.getSeedNodeUrls()) {
            String[] splits = seedUrl.split(":");
            if (splits.length != 2) {
                throw new BadSeedUrlFormatException(seedUrl);
            }
            String seedIP = splits[0];
            boolean isInvalidSeedIp = InetAddresses.isInetAddress((String)seedIP);
            if (!isInvalidSeedIp) {
                String newSeedIP = this.hostnameToIP(seedIP);
                newSeedUrls.add(newSeedIP + ":" + splits[1]);
                continue;
            }
            newSeedUrls.add(seedUrl);
        }
        this.config.setSeedNodeUrls(newSeedUrls);
        logger.debug("after replace, the rpcIP={}, internalIP={}, seedUrls={}", new Object[]{IoTDBDescriptor.getInstance().getConfig().getRpcAddress(), this.config.getInternalIp(), this.config.getSeedNodeUrls()});
    }

    private void loadProps() {
        String seedUrls;
        String url = this.getPropsUrl();
        Properties properties = System.getProperties();
        if (url != null) {
            try (FileInputStream inputStream = new FileInputStream(new File(url));){
                logger.info("Start to read config file {}", (Object)url);
                properties.load(inputStream);
            }
            catch (IOException e) {
                logger.warn("Fail to find config file {}", (Object)url, (Object)e);
            }
        }
        this.config.setInternalIp(properties.getProperty("internal_ip", this.config.getInternalIp()));
        this.config.setInternalMetaPort(Integer.parseInt(properties.getProperty("internal_meta_port", String.valueOf(this.config.getInternalMetaPort()))));
        this.config.setInternalDataPort(Integer.parseInt(properties.getProperty("internal_data_port", Integer.toString(this.config.getInternalDataPort()))));
        this.config.setClusterInfoRpcPort(Integer.parseInt(properties.getProperty("cluster_info_public_port", Integer.toString(this.config.getClusterInfoRpcPort()))));
        this.config.setMultiRaftFactor(Integer.parseInt(properties.getProperty("multi_raft_factor", String.valueOf(this.config.getMultiRaftFactor()))));
        this.config.setReplicationNum(Integer.parseInt(properties.getProperty("default_replica_num", String.valueOf(this.config.getReplicationNum()))));
        this.config.setClusterName(properties.getProperty("cluster_name", this.config.getClusterName()));
        this.config.setRpcThriftCompressionEnabled(Boolean.parseBoolean(properties.getProperty("rpc_thrift_compression_enable", String.valueOf(this.config.isRpcThriftCompressionEnabled()))));
        this.config.setConnectionTimeoutInMS(Integer.parseInt(properties.getProperty("connection_timeout_ms", String.valueOf(this.config.getConnectionTimeoutInMS()))));
        this.config.setHeartbeatIntervalMs(Long.parseLong(properties.getProperty("heartbeat_interval_ms", String.valueOf(this.config.getHeartbeatIntervalMs()))));
        this.config.setElectionTimeoutMs(Long.parseLong(properties.getProperty("election_timeout_ms", String.valueOf(this.config.getElectionTimeoutMs()))));
        this.config.setReadOperationTimeoutMS(Integer.parseInt(properties.getProperty("read_operation_timeout_ms", String.valueOf(this.config.getReadOperationTimeoutMS()))));
        this.config.setCatchUpTimeoutMS(Integer.parseInt(properties.getProperty("catch_up_timeout_ms", String.valueOf(this.config.getCatchUpTimeoutMS()))));
        this.config.setWriteOperationTimeoutMS(Integer.parseInt(properties.getProperty("write_operation_timeout_ms", String.valueOf(this.config.getWriteOperationTimeoutMS()))));
        this.config.setUseBatchInLogCatchUp(Boolean.parseBoolean(properties.getProperty("use_batch_in_catch_up", String.valueOf(this.config.isUseBatchInLogCatchUp()))));
        this.config.setMinNumOfLogsInMem(Integer.parseInt(properties.getProperty("min_num_of_logs_in_mem", String.valueOf(this.config.getMinNumOfLogsInMem()))));
        this.config.setMaxNumOfLogsInMem(Integer.parseInt(properties.getProperty("max_num_of_logs_in_mem", String.valueOf(this.config.getMaxNumOfLogsInMem()))));
        this.config.setRaftLogMemoryProportion(Double.parseDouble(properties.getProperty("raft_log_memory_proportion", String.valueOf(this.config.getRaftLogMemoryProportion()))));
        this.config.setLogDeleteCheckIntervalSecond(Integer.parseInt(properties.getProperty("log_deletion_check_interval_second", String.valueOf(this.config.getLogDeleteCheckIntervalSecond()))));
        this.config.setEnableAutoCreateSchema(Boolean.parseBoolean(properties.getProperty("enable_auto_create_schema", String.valueOf(this.config.isEnableAutoCreateSchema()))));
        this.config.setUseAsyncServer(Boolean.parseBoolean(properties.getProperty("is_use_async_server", String.valueOf(this.config.isUseAsyncServer()))));
        this.config.setOpenServerRpcPort(Boolean.parseBoolean(properties.getProperty("open_server_rpc_port", String.valueOf(this.config.isOpenServerRpcPort()))));
        this.config.setUseAsyncApplier(Boolean.parseBoolean(properties.getProperty("is_use_async_applier", String.valueOf(this.config.isUseAsyncApplier()))));
        this.config.setEnableRaftLogPersistence(Boolean.parseBoolean(properties.getProperty("is_enable_raft_log_persistence", String.valueOf(this.config.isEnableRaftLogPersistence()))));
        this.config.setFlushRaftLogThreshold(Integer.parseInt(properties.getProperty("flush_raft_log_threshold", String.valueOf(this.config.getFlushRaftLogThreshold()))));
        this.config.setRaftLogBufferSize(Integer.parseInt(properties.getProperty("raft_log_buffer_size", String.valueOf(this.config.getRaftLogBufferSize()))));
        this.config.setMaxRaftLogIndexSizeInMemory(Integer.parseInt(properties.getProperty("max_raft_log_index_size_in_memory", String.valueOf(this.config.getMaxRaftLogIndexSizeInMemory()))));
        this.config.setUnCommittedRaftLogNumForRejectThreshold(Integer.parseInt(properties.getProperty("uncommitted_raft_log_num_for_reject_threshold", String.valueOf(this.config.getUnCommittedRaftLogNumForRejectThreshold()))));
        this.config.setUnAppliedRaftLogNumForRejectThreshold(Integer.parseInt(properties.getProperty("unapplied_raft_log_num_for_reject_threshold", String.valueOf(this.config.getUnAppliedRaftLogNumForRejectThreshold()))));
        this.config.setMaxRaftLogPersistDataSizePerFile(Integer.parseInt(properties.getProperty("max_raft_log_persist_data_size_per_file", String.valueOf(this.config.getMaxRaftLogPersistDataSizePerFile()))));
        this.config.setMaxNumberOfPersistRaftLogFiles(Integer.parseInt(properties.getProperty("max_number_of_persist_raft_log_files", String.valueOf(this.config.getMaxNumberOfPersistRaftLogFiles()))));
        this.config.setMaxPersistRaftLogNumberOnDisk(Integer.parseInt(properties.getProperty("max_persist_raft_log_number_on_disk", String.valueOf(this.config.getMaxPersistRaftLogNumberOnDisk()))));
        this.config.setMaxNumberOfLogsPerFetchOnDisk(Integer.parseInt(properties.getProperty("max_number_of_logs_per_fetch_on_disk", String.valueOf(this.config.getMaxNumberOfLogsPerFetchOnDisk()))));
        this.config.setEnableUsePersistLogOnDiskToCatchUp(Boolean.parseBoolean(properties.getProperty("enable_use_persist_log_on_disk_to_catch_up", String.valueOf(this.config.isEnableUsePersistLogOnDiskToCatchUp()))));
        this.config.setMaxReadLogLag(Long.parseLong(properties.getProperty("max_read_log_lag", String.valueOf(this.config.getMaxReadLogLag()))));
        this.config.setMaxSyncLogLag(Long.parseLong(properties.getProperty("max_sync_log_lag", String.valueOf(this.config.getMaxSyncLogLag()))));
        this.config.setMaxClientPerNodePerMember(Integer.parseInt(properties.getProperty("max_client_pernode_permember_number", String.valueOf(this.config.getMaxClientPerNodePerMember()))));
        this.config.setMaxIdleClientPerNodePerMember(Integer.parseInt(properties.getProperty("max_idle_client_pernode_permember_number", String.valueOf(this.config.getMaxIdleClientPerNodePerMember()))));
        this.config.setWaitClientTimeoutMS(Long.parseLong(properties.getProperty("wait_client_timeout_ms", String.valueOf(this.config.getWaitClientTimeoutMS()))));
        String consistencyLevel = properties.getProperty("consistency_level");
        if (consistencyLevel != null) {
            this.config.setConsistencyLevel(ConsistencyLevel.getConsistencyLevel(consistencyLevel));
        }
        if ((seedUrls = properties.getProperty("seed_nodes")) != null) {
            List<String> urlList = ClusterDescriptor.getSeedUrlList(seedUrls);
            this.config.setSeedNodeUrls(urlList);
        }
    }

    public static List<String> getSeedUrlList(String seedUrls) {
        String[] split;
        if (seedUrls == null) {
            return Collections.emptyList();
        }
        ArrayList<String> urlList = new ArrayList<String>();
        for (String nodeUrl : split = seedUrls.split(",")) {
            if ("".equals(nodeUrl = nodeUrl.trim())) continue;
            urlList.add(nodeUrl);
        }
        return urlList;
    }

    public void loadHotModifiedProps() throws QueryProcessException {
        Properties properties = this.getProperties();
        if (properties != null) {
            this.loadHotModifiedProps(properties);
        }
    }

    private Properties getProperties() throws QueryProcessException {
        Properties properties;
        String url = this.getPropsUrl();
        if (url == null) {
            return null;
        }
        try (FileInputStream inputStream = new FileInputStream(new File(url));){
            logger.info("Start to reload config file {}", (Object)url);
            properties = new Properties();
            properties.load(inputStream);
        }
        catch (Exception e) {
            throw new QueryProcessException(String.format("Fail to reload config file %s because %s", url, e.getMessage()));
        }
        return properties;
    }

    public void loadHotModifiedProps(Properties properties) {
        this.config.setConnectionTimeoutInMS(Integer.parseInt(properties.getProperty("connection_timeout_ms", String.valueOf(this.config.getConnectionTimeoutInMS()))));
        logger.info("Set cluster configuration {}", (Object)properties);
    }

    private String hostnameToIP(String hostname) throws UnknownHostException {
        InetAddress address = InetAddress.getByName(hostname);
        return address.getHostAddress();
    }
}

