/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.log.logtypes;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.cluster.log.Log;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.utils.NodeSerializeUtils;

public class RemoveNodeLog
extends Log {
    private ByteBuffer partitionTable;
    private Node removedNode;
    private long metaLogIndex;

    public RemoveNodeLog(ByteBuffer partitionTable, Node removedNode) {
        this.partitionTable = partitionTable;
        this.removedNode = removedNode;
    }

    public RemoveNodeLog() {
    }

    public long getMetaLogIndex() {
        return this.metaLogIndex;
    }

    public void setMetaLogIndex(long metaLogIndex) {
        this.metaLogIndex = metaLogIndex;
    }

    public ByteBuffer getPartitionTable() {
        this.partitionTable.rewind();
        return this.partitionTable;
    }

    public void setPartitionTable(ByteBuffer partitionTable) {
        this.partitionTable = partitionTable;
    }

    @Override
    public ByteBuffer serialize() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);){
            dataOutputStream.writeByte(Log.Types.REMOVE_NODE.ordinal());
            dataOutputStream.writeLong(this.getCurrLogIndex());
            dataOutputStream.writeLong(this.getCurrLogTerm());
            dataOutputStream.writeLong(this.getMetaLogIndex());
            NodeSerializeUtils.serialize(this.removedNode, dataOutputStream);
            dataOutputStream.writeInt(this.partitionTable.array().length);
            dataOutputStream.write(this.partitionTable.array());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
    }

    @Override
    public void deserialize(ByteBuffer buffer) {
        this.setCurrLogIndex(buffer.getLong());
        this.setCurrLogTerm(buffer.getLong());
        this.setMetaLogIndex(buffer.getLong());
        this.removedNode = new Node();
        NodeSerializeUtils.deserialize(this.removedNode, buffer);
        int len = buffer.getInt();
        byte[] data = new byte[len];
        System.arraycopy(buffer.array(), buffer.position(), data, 0, len);
        this.partitionTable = ByteBuffer.wrap(data);
    }

    public Node getRemovedNode() {
        return this.removedNode;
    }

    public void setRemovedNode(Node removedNode) {
        this.removedNode = removedNode;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RemoveNodeLog that = (RemoveNodeLog)o;
        return Objects.equals(this.removedNode, that.removedNode) && Objects.equals(this.partitionTable, that.partitionTable);
    }

    public String toString() {
        return "RemoveNodeLog{removedNode=" + this.removedNode.toString() + '}';
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.removedNode, this.partitionTable);
    }
}

