/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.partition.slot;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.cluster.partition.NodeRemovalResult;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.rpc.thrift.RaftNode;
import org.apache.iotdb.cluster.utils.NodeSerializeUtils;

public class SlotNodeRemovalResult
extends NodeRemovalResult {
    private Map<RaftNode, List<Integer>> newSlotOwners = new HashMap<RaftNode, List<Integer>>();

    public Map<RaftNode, List<Integer>> getNewSlotOwners() {
        return this.newSlotOwners;
    }

    public void addNewSlotOwners(Map<RaftNode, List<Integer>> newSlotOwners) {
        this.newSlotOwners = newSlotOwners;
    }

    @Override
    public void serialize(DataOutputStream dataOutputStream) throws IOException {
        super.serialize(dataOutputStream);
        dataOutputStream.writeInt(this.newSlotOwners.size());
        for (Map.Entry<RaftNode, List<Integer>> entry : this.newSlotOwners.entrySet()) {
            RaftNode raftNode = entry.getKey();
            NodeSerializeUtils.serialize(raftNode.getNode(), dataOutputStream);
            dataOutputStream.writeInt(raftNode.getRaftId());
            dataOutputStream.writeInt(entry.getValue().size());
            for (Integer slot : entry.getValue()) {
                dataOutputStream.writeInt(slot);
            }
        }
    }

    @Override
    public void deserialize(ByteBuffer buffer) {
        super.deserialize(buffer);
        int size = buffer.getInt();
        for (int i = 0; i < size; ++i) {
            Node node = new Node();
            NodeSerializeUtils.deserialize(node, buffer);
            RaftNode raftNode = new RaftNode(node, buffer.getInt());
            ArrayList<Integer> slots = new ArrayList<Integer>();
            int slotSize = buffer.getInt();
            for (int j = 0; j < slotSize; ++j) {
                slots.add(buffer.getInt());
            }
            this.newSlotOwners.put(raftNode, slots);
        }
    }
}

