/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.server.handlers.caller;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.thrift.async.AsyncMethodCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetTimeseriesSchemaHandler
implements AsyncMethodCallback<ByteBuffer> {
    private static final Logger logger = LoggerFactory.getLogger(GetTimeseriesSchemaHandler.class);
    private Node contact;
    private AtomicReference<ByteBuffer> result;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onComplete(ByteBuffer resp) {
        logger.info("Received timeseries schema from {}", (Object)this.contact);
        AtomicReference<ByteBuffer> atomicReference = this.result;
        synchronized (atomicReference) {
            this.result.set(resp);
            this.result.notifyAll();
        }
    }

    public void onError(Exception exception) {
        logger.warn("Cannot get timeseries schema from {}, because ", (Object)this.contact, (Object)exception);
    }

    public void setResponse(AtomicReference<ByteBuffer> response) {
        this.result = response;
    }

    public void setContact(Node contact) {
        this.contact = contact;
    }
}

