/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.utils.nodetool.function;

import io.airlift.airline.Command;
import io.airlift.airline.Option;
import java.util.List;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.server.NodeCharacter;
import org.apache.iotdb.cluster.utils.nodetool.ClusterMonitorMBean;
import org.apache.iotdb.cluster.utils.nodetool.Printer;
import org.apache.iotdb.cluster.utils.nodetool.function.NodeToolCmd;
import org.apache.iotdb.tsfile.utils.Pair;

@Command(name="header", description="Print information about data group whose header is this node")
public class Header
extends NodeToolCmd {
    @Option(title="raft id", name={"-id", "--raftid"}, description="Specify the raft id of data group whose header is this node, default value is 0")
    private int id = 0;

    @Override
    public void execute(ClusterMonitorMBean proxy) {
        try {
            List<Pair<Node, NodeCharacter>> allNodes = proxy.getDataGroup(this.id);
            if (allNodes == null) {
                Printer.msgPrintln("The cluster is being created.");
                return;
            }
            Printer.msgPrintln(String.format("%-20s  %30s", "Node Identifier", "Node"));
            for (Pair<Node, NodeCharacter> pair : allNodes) {
                Node node = (Node)pair.left;
                Printer.msgPrintln(String.format("%-20d->%30s", node.nodeIdentifier, Header.nodeCharacterToString(node, (NodeCharacter)((Object)pair.right))));
            }
        }
        catch (Exception e) {
            Printer.msgPrintln(e.getMessage());
        }
    }
}

