/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.utils.nodetool.function;

import io.airlift.airline.Command;
import java.util.List;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.server.NodeCharacter;
import org.apache.iotdb.cluster.utils.nodetool.ClusterMonitorMBean;
import org.apache.iotdb.cluster.utils.nodetool.Printer;
import org.apache.iotdb.cluster.utils.nodetool.function.NodeToolCmd;
import org.apache.iotdb.tsfile.utils.Pair;

@Command(name="ring", description="Print information about the meta raft group")
public class Ring
extends NodeToolCmd {
    @Override
    public void execute(ClusterMonitorMBean proxy) {
        List<Pair<Node, NodeCharacter>> allNodes = proxy.getMetaGroup();
        if (allNodes == null) {
            Printer.msgPrintln("The cluster is being created.");
        } else {
            Printer.msgPrintln(String.format("%-20s  %30s", "Node Identifier", "Node"));
            for (Pair<Node, NodeCharacter> pair : allNodes) {
                Node node = (Node)pair.left;
                Printer.msgPrintln(String.format("%-20d->%30s", node.nodeIdentifier, Ring.nodeCharacterToString(node, (NodeCharacter)((Object)pair.right))));
            }
        }
    }
}

