/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.file.header;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.file.MetaMarker;
import org.apache.iotdb.tsfile.read.reader.TsFileInput;
import org.apache.iotdb.tsfile.utils.ReadWriteForEncodingUtils;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class ChunkGroupHeader {
    private static final byte MARKER = 0;
    private final String deviceID;
    private int serializedSize;

    public ChunkGroupHeader(String deviceID) {
        this.deviceID = deviceID;
        this.serializedSize = this.getSerializedSize(deviceID);
    }

    private int getSerializedSize(String deviceID) {
        int length = deviceID.getBytes(TSFileConfig.STRING_CHARSET).length;
        return 1 + ReadWriteForEncodingUtils.varIntSize(length) + length;
    }

    public static ChunkGroupHeader deserializeFrom(InputStream inputStream, boolean markerRead) throws IOException {
        byte marker;
        if (!markerRead && (marker = (byte)inputStream.read()) != 0) {
            MetaMarker.handleUnexpectedMarker(marker);
        }
        String deviceID = ReadWriteIOUtils.readVarIntString(inputStream);
        return new ChunkGroupHeader(deviceID);
    }

    public static ChunkGroupHeader deserializeFrom(TsFileInput input, long offset, boolean markerRead) throws IOException {
        long offsetVar = offset;
        if (!markerRead) {
            ++offsetVar;
        }
        String deviceID = input.readVarIntString(offsetVar);
        return new ChunkGroupHeader(deviceID);
    }

    public int getSerializedSize() {
        return this.serializedSize;
    }

    public String getDeviceID() {
        return this.deviceID;
    }

    public int serializeTo(OutputStream outputStream) throws IOException {
        int length = 0;
        length += ReadWriteIOUtils.write((byte)0, outputStream);
        return length += ReadWriteIOUtils.writeVar(this.deviceID, outputStream);
    }

    public String toString() {
        return "ChunkGroupHeader{deviceID='" + this.deviceID + '\'' + ", serializedSize=" + this.serializedSize + '}';
    }
}

