/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.memtable;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.memtable.AlignedWritableMemChunkGroup;
import org.apache.iotdb.db.engine.memtable.IMemTable;
import org.apache.iotdb.db.engine.memtable.IWritableMemChunkGroup;
import org.apache.iotdb.db.engine.memtable.WritableMemChunkGroup;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.engine.querycontext.ReadOnlyMemChunk;
import org.apache.iotdb.db.exception.WriteProcessException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.idtable.entry.DeviceIDFactory;
import org.apache.iotdb.db.metadata.idtable.entry.IDeviceID;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertTabletPlan;
import org.apache.iotdb.db.service.metrics.MetricService;
import org.apache.iotdb.db.service.metrics.enums.Metric;
import org.apache.iotdb.db.service.metrics.enums.Tag;
import org.apache.iotdb.db.utils.MemUtils;
import org.apache.iotdb.metrics.config.MetricConfigDescriptor;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMemTable
implements IMemTable {
    private final Map<IDeviceID, IWritableMemChunkGroup> memTableMap;
    protected boolean disableMemControl = true;
    private static final Logger logger = LoggerFactory.getLogger(AbstractMemTable.class);
    private boolean shouldFlush = false;
    private final int avgSeriesPointNumThreshold = IoTDBDescriptor.getInstance().getConfig().getAvgSeriesPointNumberThreshold();
    private long memSize = 0L;
    private long tvListRamCost = 0L;
    private int seriesNumber = 0;
    private long totalPointsNum = 0L;
    private long totalPointsNumThreshold = 0L;
    private long maxPlanIndex = Long.MIN_VALUE;
    private long minPlanIndex = Long.MAX_VALUE;
    private long createdTime = System.currentTimeMillis();
    private static final String METRIC_POINT_IN = "pointsIn";

    public AbstractMemTable() {
        this.memTableMap = new HashMap<IDeviceID, IWritableMemChunkGroup>();
    }

    public AbstractMemTable(Map<IDeviceID, IWritableMemChunkGroup> memTableMap) {
        this.memTableMap = memTableMap;
    }

    @Override
    public Map<IDeviceID, IWritableMemChunkGroup> getMemTableMap() {
        return this.memTableMap;
    }

    private IWritableMemChunkGroup createMemChunkGroupIfNotExistAndGet(IDeviceID deviceId, List<IMeasurementSchema> schemaList) {
        IWritableMemChunkGroup memChunkGroup = this.memTableMap.computeIfAbsent(deviceId, k -> new WritableMemChunkGroup());
        for (IMeasurementSchema schema : schemaList) {
            if (memChunkGroup.contains(schema.getMeasurementId())) continue;
            ++this.seriesNumber;
            this.totalPointsNumThreshold += (long)this.avgSeriesPointNumThreshold;
        }
        return memChunkGroup;
    }

    private IWritableMemChunkGroup createAlignedMemChunkGroupIfNotExistAndGet(IDeviceID deviceId, List<IMeasurementSchema> schemaList) {
        IWritableMemChunkGroup memChunkGroup = this.memTableMap.computeIfAbsent(deviceId, k -> {
            this.seriesNumber += schemaList.size();
            this.totalPointsNumThreshold += (long)this.avgSeriesPointNumThreshold * (long)schemaList.size();
            return new AlignedWritableMemChunkGroup(schemaList);
        });
        for (IMeasurementSchema schema : schemaList) {
            if (memChunkGroup.contains(schema.getMeasurementId())) continue;
            ++this.seriesNumber;
            this.totalPointsNumThreshold += (long)this.avgSeriesPointNumThreshold;
        }
        return memChunkGroup;
    }

    @Override
    public void insert(InsertRowPlan insertRowPlan) {
        if (insertRowPlan.getDeviceID() == null) {
            insertRowPlan.setDeviceID(DeviceIDFactory.getInstance().getDeviceID(insertRowPlan.getDevicePath()));
        }
        this.updatePlanIndexes(insertRowPlan.getIndex());
        String[] measurements = insertRowPlan.getMeasurements();
        Object[] values = insertRowPlan.getValues();
        ArrayList<IMeasurementSchema> schemaList = new ArrayList<IMeasurementSchema>();
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        int nullPointsNumber = 0;
        for (int i = 0; i < insertRowPlan.getMeasurements().length; ++i) {
            if (measurements[i] == null) continue;
            if (values[i] == null) {
                ++nullPointsNumber;
                continue;
            }
            IMeasurementSchema schema = insertRowPlan.getMeasurementMNodes()[i].getSchema();
            schemaList.add(schema);
            dataTypes.add(schema.getType());
        }
        this.memSize += MemUtils.getRecordsSize(dataTypes, values, this.disableMemControl);
        this.write(insertRowPlan.getDeviceID(), insertRowPlan.getFailedIndices(), schemaList, insertRowPlan.getTime(), values);
        int pointsInserted = insertRowPlan.getMeasurements().length - insertRowPlan.getFailedMeasurementNumber() - nullPointsNumber;
        this.totalPointsNum += (long)pointsInserted;
        if (MetricConfigDescriptor.getInstance().getMetricConfig().getEnableMetric().booleanValue()) {
            MetricService.getInstance().count(pointsInserted, Metric.QUANTITY.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), METRIC_POINT_IN, Tag.TYPE.toString(), "insertRow"});
        }
    }

    @Override
    public void insertAlignedRow(InsertRowPlan insertRowPlan) {
        if (insertRowPlan.getDeviceID() == null) {
            insertRowPlan.setDeviceID(DeviceIDFactory.getInstance().getDeviceID(insertRowPlan.getDevicePath()));
        }
        this.updatePlanIndexes(insertRowPlan.getIndex());
        String[] measurements = insertRowPlan.getMeasurements();
        Object[] values = insertRowPlan.getValues();
        ArrayList<IMeasurementSchema> schemaList = new ArrayList<IMeasurementSchema>();
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        for (int i = 0; i < insertRowPlan.getMeasurements().length; ++i) {
            if (measurements[i] == null) continue;
            IMeasurementSchema schema = insertRowPlan.getMeasurementMNodes()[i].getSchema();
            schemaList.add(schema);
            dataTypes.add(schema.getType());
        }
        if (schemaList.isEmpty()) {
            return;
        }
        this.memSize += MemUtils.getAlignedRecordsSize(dataTypes, values, this.disableMemControl);
        this.writeAlignedRow(insertRowPlan.getDeviceID(), insertRowPlan.getFailedIndices(), schemaList, insertRowPlan.getTime(), values);
        int pointsInserted = insertRowPlan.getMeasurements().length - insertRowPlan.getFailedMeasurementNumber();
        this.totalPointsNum += (long)pointsInserted;
        if (MetricConfigDescriptor.getInstance().getMetricConfig().getEnableMetric().booleanValue()) {
            MetricService.getInstance().count(pointsInserted, Metric.QUANTITY.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), METRIC_POINT_IN, Tag.TYPE.toString(), "insertAlignedRow"});
        }
    }

    @Override
    public void insertTablet(InsertTabletPlan insertTabletPlan, int start, int end) throws WriteProcessException {
        this.updatePlanIndexes(insertTabletPlan.getIndex());
        try {
            this.write(insertTabletPlan, start, end);
            this.memSize += MemUtils.getTabletSize(insertTabletPlan, start, end, this.disableMemControl);
            int pointsInserted = (insertTabletPlan.getDataTypes().length - insertTabletPlan.getFailedMeasurementNumber()) * (end - start);
            this.totalPointsNum += (long)pointsInserted;
            if (MetricConfigDescriptor.getInstance().getMetricConfig().getEnableMetric().booleanValue()) {
                MetricService.getInstance().count(pointsInserted, Metric.QUANTITY.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), METRIC_POINT_IN, Tag.TYPE.toString(), "insertTablet"});
            }
        }
        catch (RuntimeException e) {
            throw new WriteProcessException(e);
        }
    }

    @Override
    public void insertAlignedTablet(InsertTabletPlan insertTabletPlan, int start, int end) throws WriteProcessException {
        this.updatePlanIndexes(insertTabletPlan.getIndex());
        try {
            this.writeAlignedTablet(insertTabletPlan, start, end);
            this.memSize += MemUtils.getAlignedTabletSize(insertTabletPlan, start, end, this.disableMemControl);
            int pointsInserted = (insertTabletPlan.getDataTypes().length - insertTabletPlan.getFailedMeasurementNumber()) * (end - start);
            this.totalPointsNum += (long)pointsInserted;
            if (MetricConfigDescriptor.getInstance().getMetricConfig().getEnableMetric().booleanValue()) {
                MetricService.getInstance().count(pointsInserted, Metric.QUANTITY.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), METRIC_POINT_IN, Tag.TYPE.toString(), "insertAlignedTablet"});
            }
        }
        catch (RuntimeException e) {
            throw new WriteProcessException(e);
        }
    }

    @Override
    public void write(IDeviceID deviceId, List<Integer> failedIndices, List<IMeasurementSchema> schemaList, long insertTime, Object[] objectValue) {
        IWritableMemChunkGroup memChunkGroup = this.createMemChunkGroupIfNotExistAndGet(deviceId, schemaList);
        memChunkGroup.write(insertTime, objectValue, failedIndices, schemaList);
    }

    @Override
    public void writeAlignedRow(IDeviceID deviceId, List<Integer> failedIndices, List<IMeasurementSchema> schemaList, long insertTime, Object[] objectValue) {
        IWritableMemChunkGroup memChunkGroup = this.createAlignedMemChunkGroupIfNotExistAndGet(deviceId, schemaList);
        memChunkGroup.write(insertTime, objectValue, failedIndices, schemaList);
    }

    @Override
    public void write(InsertTabletPlan insertTabletPlan, int start, int end) {
        if (insertTabletPlan.getDeviceID() == null) {
            insertTabletPlan.setDeviceID(DeviceIDFactory.getInstance().getDeviceID(insertTabletPlan.getDevicePath()));
        }
        ArrayList<IMeasurementSchema> schemaList = new ArrayList<IMeasurementSchema>();
        for (int i = 0; i < insertTabletPlan.getMeasurements().length; ++i) {
            if (insertTabletPlan.getColumns()[i] == null) continue;
            IMeasurementSchema schema = insertTabletPlan.getMeasurementMNodes()[i].getSchema();
            schemaList.add(schema);
        }
        IWritableMemChunkGroup memChunkGroup = this.createMemChunkGroupIfNotExistAndGet(insertTabletPlan.getDeviceID(), schemaList);
        memChunkGroup.writeValues(insertTabletPlan.getTimes(), insertTabletPlan.getColumns(), insertTabletPlan.getBitMaps(), insertTabletPlan.getFailedIndices(), schemaList, start, end);
    }

    @Override
    public void writeAlignedTablet(InsertTabletPlan insertTabletPlan, int start, int end) {
        if (insertTabletPlan.getDeviceID() == null) {
            insertTabletPlan.setDeviceID(DeviceIDFactory.getInstance().getDeviceID(insertTabletPlan.getDevicePath()));
        }
        ArrayList<IMeasurementSchema> schemaList = new ArrayList<IMeasurementSchema>();
        for (int i = 0; i < insertTabletPlan.getMeasurements().length; ++i) {
            if (insertTabletPlan.getColumns()[i] == null) continue;
            IMeasurementSchema schema = insertTabletPlan.getMeasurementMNodes()[i].getSchema();
            schemaList.add(schema);
        }
        if (schemaList.isEmpty()) {
            return;
        }
        IWritableMemChunkGroup memChunkGroup = this.createAlignedMemChunkGroupIfNotExistAndGet(insertTabletPlan.getDeviceID(), schemaList);
        memChunkGroup.writeValues(insertTabletPlan.getTimes(), insertTabletPlan.getColumns(), insertTabletPlan.getBitMaps(), insertTabletPlan.getFailedIndices(), schemaList, start, end);
    }

    @Override
    public boolean checkIfChunkDoesNotExist(IDeviceID deviceId, String measurement) {
        IWritableMemChunkGroup memChunkGroup = this.memTableMap.get(deviceId);
        if (null == memChunkGroup) {
            return true;
        }
        return !memChunkGroup.contains(measurement);
    }

    @Override
    public long getCurrentTVListSize(IDeviceID deviceId, String measurement) {
        IWritableMemChunkGroup memChunkGroup = this.memTableMap.get(deviceId);
        return memChunkGroup.getCurrentTVListSize(measurement);
    }

    @Override
    public int getSeriesNumber() {
        return this.seriesNumber;
    }

    @Override
    public long getTotalPointsNum() {
        return this.totalPointsNum;
    }

    @Override
    public long size() {
        long sum = 0L;
        for (IWritableMemChunkGroup writableMemChunkGroup : this.memTableMap.values()) {
            sum += writableMemChunkGroup.count();
        }
        return sum;
    }

    @Override
    public long memSize() {
        return this.memSize;
    }

    @Override
    public boolean reachTotalPointNumThreshold() {
        if (this.totalPointsNum == 0L) {
            return false;
        }
        return this.totalPointsNum >= this.totalPointsNumThreshold;
    }

    @Override
    public void clear() {
        this.memTableMap.clear();
        this.memSize = 0L;
        this.seriesNumber = 0;
        this.totalPointsNum = 0L;
        this.totalPointsNumThreshold = 0L;
        this.tvListRamCost = 0L;
        this.maxPlanIndex = 0L;
    }

    @Override
    public boolean isEmpty() {
        return this.memTableMap.isEmpty();
    }

    @Override
    public ReadOnlyMemChunk query(PartialPath fullPath, long ttlLowerBound, List<Pair<Modification, IMemTable>> modsToMemtable) throws IOException, QueryProcessException {
        return fullPath.getReadOnlyMemChunkFromMemTable(this, modsToMemtable, ttlLowerBound);
    }

    @Override
    public void delete(PartialPath originalPath, PartialPath devicePath, long startTimestamp, long endTimestamp) {
        IWritableMemChunkGroup memChunkGroup = this.memTableMap.get(this.getDeviceID(devicePath));
        if (memChunkGroup == null) {
            return;
        }
        this.totalPointsNum -= (long)memChunkGroup.delete(originalPath, devicePath, startTimestamp, endTimestamp);
        if (memChunkGroup.getMemChunkMap().isEmpty()) {
            this.memTableMap.remove(this.getDeviceID(devicePath));
        }
    }

    @Override
    public void addTVListRamCost(long cost) {
        this.tvListRamCost += cost;
    }

    @Override
    public void releaseTVListRamCost(long cost) {
        this.tvListRamCost -= cost;
    }

    @Override
    public long getTVListsRamCost() {
        return this.tvListRamCost;
    }

    @Override
    public void addTextDataSize(long textDataSize) {
        this.memSize += textDataSize;
    }

    @Override
    public void releaseTextDataSize(long textDataSize) {
        this.memSize -= textDataSize;
    }

    @Override
    public void setShouldFlush() {
        this.shouldFlush = true;
    }

    @Override
    public boolean shouldFlush() {
        return this.shouldFlush;
    }

    @Override
    public void release() {
        for (Map.Entry<IDeviceID, IWritableMemChunkGroup> entry : this.memTableMap.entrySet()) {
            entry.getValue().release();
        }
    }

    @Override
    public long getMaxPlanIndex() {
        return this.maxPlanIndex;
    }

    @Override
    public long getMinPlanIndex() {
        return this.minPlanIndex;
    }

    void updatePlanIndexes(long index) {
        this.maxPlanIndex = Math.max(index, this.maxPlanIndex);
        this.minPlanIndex = Math.min(index, this.minPlanIndex);
    }

    @Override
    public long getCreatedTime() {
        return this.createdTime;
    }

    private IDeviceID getDeviceID(PartialPath deviceId) {
        return DeviceIDFactory.getInstance().getDeviceID(deviceId);
    }
}

