/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.logical.sys;

import java.io.File;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.exception.runtime.SQLParserException;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.sys.SetArchivingPlan;
import org.apache.iotdb.db.qp.strategy.PhysicalGenerator;

public class SetArchivingOperator
extends Operator {
    private PartialPath storageGroup = null;
    private File targetDir = null;
    private Long ttl = null;
    private Long startTime = null;

    public SetArchivingOperator(int tokenIntType) {
        super(tokenIntType);
        this.operatorType = Operator.OperatorType.SET_ARCHIVING;
    }

    public PartialPath getStorageGroup() {
        return this.storageGroup;
    }

    public void setStorageGroup(PartialPath storageGroup) {
        this.storageGroup = storageGroup;
    }

    public File getTargetDir() {
        return this.targetDir;
    }

    public void setTargetDir(File targetDir) {
        this.targetDir = targetDir;
    }

    public long getTTL() {
        return this.ttl;
    }

    public void setTTL(long ttl) {
        this.ttl = ttl;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    @Override
    public PhysicalPlan generatePhysicalPlan(PhysicalGenerator generator) throws QueryProcessException {
        if (this.storageGroup == null) {
            throw new SQLParserException("storage_group not specified");
        }
        if (this.startTime == null) {
            throw new SQLParserException("start_time not specified");
        }
        if (this.ttl == null) {
            throw new SQLParserException("ttl not specified");
        }
        if (this.targetDir == null) {
            throw new SQLParserException("target_dir not specified");
        }
        return new SetArchivingPlan(this.storageGroup, this.targetDir, this.ttl, this.startTime);
    }
}

