/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.client.async.handlers.rpc;

import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.confignode.client.async.CnToDnAsyncRequestType;
import org.apache.iotdb.confignode.client.async.handlers.rpc.DataNodeAsyncRequestRPCHandler;
import org.apache.iotdb.mpp.rpc.thrift.TFetchSchemaBlackListResp;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FetchSchemaBlackListRPCHandler
extends DataNodeAsyncRequestRPCHandler<TFetchSchemaBlackListResp> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FetchSchemaBlackListRPCHandler.class);

    public FetchSchemaBlackListRPCHandler(CnToDnAsyncRequestType requestType, int requestId, TDataNodeLocation targetDataNode, Map<Integer, TDataNodeLocation> dataNodeLocationMap, Map<Integer, TFetchSchemaBlackListResp> responseMap, CountDownLatch countDownLatch) {
        super(requestType, requestId, targetDataNode, dataNodeLocationMap, responseMap, countDownLatch);
    }

    public void onComplete(TFetchSchemaBlackListResp tFetchSchemaBlackListResp) {
        TSStatus tsStatus = tFetchSchemaBlackListResp.getStatus();
        this.responseMap.put(this.requestId, tFetchSchemaBlackListResp);
        if (tsStatus.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            this.nodeLocationMap.remove(this.requestId);
            LOGGER.info("Successfully fetch schemaengine black list on DataNode: {}", this.targetNode);
        } else if (tsStatus.getCode() == TSStatusCode.MULTIPLE_ERROR.getStatusCode()) {
            this.nodeLocationMap.remove(this.requestId);
            LOGGER.error("Failed to fetch schemaengine black list on DataNode {}, {}", this.targetNode, (Object)tsStatus);
        } else {
            LOGGER.error("Failed to fetch schemaengine black list on DataNode {}, {}", this.targetNode, (Object)tsStatus);
        }
        this.countDownLatch.countDown();
    }

    public void onError(Exception e) {
        String errorMsg = "Fetch schemaengine black list error on DataNode: {id=" + ((TDataNodeLocation)this.targetNode).getDataNodeId() + ", internalEndPoint=" + ((TDataNodeLocation)this.targetNode).getInternalEndPoint() + "}" + e.getMessage();
        LOGGER.error(errorMsg);
        this.countDownLatch.countDown();
        TFetchSchemaBlackListResp resp = new TFetchSchemaBlackListResp();
        resp.setStatus(new TSStatus(RpcUtils.getStatus((int)TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode(), (String)errorMsg)));
        this.responseMap.put(this.requestId, resp);
    }
}

