/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.analyze;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.auth.AuthException;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.exception.ClientManagerException;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.consensus.ConfigRegionId;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.SchemaConstant;
import org.apache.iotdb.commons.service.metric.PerformanceOverviewMetrics;
import org.apache.iotdb.confignode.rpc.thrift.TGetDatabaseReq;
import org.apache.iotdb.confignode.rpc.thrift.TShowDatabaseResp;
import org.apache.iotdb.db.auth.AuthorityChecker;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.LoadAnalyzeException;
import org.apache.iotdb.db.exception.LoadAnalyzeTypeMismatchException;
import org.apache.iotdb.db.exception.load.LoadEmptyFileException;
import org.apache.iotdb.db.exception.load.LoadFileException;
import org.apache.iotdb.db.exception.load.LoadRuntimeOutOfMemoryException;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.protocol.client.ConfigNodeClient;
import org.apache.iotdb.db.protocol.client.ConfigNodeClientManager;
import org.apache.iotdb.db.protocol.client.ConfigNodeInfo;
import org.apache.iotdb.db.protocol.session.SessionManager;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.common.schematree.DeviceSchemaInfo;
import org.apache.iotdb.db.queryengine.common.schematree.ISchemaTree;
import org.apache.iotdb.db.queryengine.plan.Coordinator;
import org.apache.iotdb.db.queryengine.plan.analyze.Analysis;
import org.apache.iotdb.db.queryengine.plan.analyze.IPartitionFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ISchemaFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.SchemaValidator;
import org.apache.iotdb.db.queryengine.plan.execution.ExecutionResult;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.LoadTsFileStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.DatabaseSchemaStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.ShowDatabaseStatement;
import org.apache.iotdb.db.storageengine.dataregion.modification.Deletion;
import org.apache.iotdb.db.storageengine.dataregion.modification.Modification;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResourceStatus;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.FileTimeIndex;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.ITimeIndex;
import org.apache.iotdb.db.storageengine.dataregion.utils.TsFileResourceUtils;
import org.apache.iotdb.db.storageengine.load.converter.LoadTsFileDataTypeConverter;
import org.apache.iotdb.db.storageengine.load.memory.LoadTsFileMemoryBlock;
import org.apache.iotdb.db.storageengine.load.memory.LoadTsFileMemoryManager;
import org.apache.iotdb.db.storageengine.load.metrics.LoadTsFileCostMetricsSet;
import org.apache.iotdb.db.utils.ModificationUtils;
import org.apache.iotdb.db.utils.TimestampPrecisionUtils;
import org.apache.iotdb.db.utils.constant.SqlConstant;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.TException;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.PlainDeviceID;
import org.apache.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.tsfile.file.metadata.enums.CompressionType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.read.TsFileSequenceReader;
import org.apache.tsfile.read.TsFileSequenceReaderTimeseriesMetadataIterator;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.write.schema.MeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadTsFileAnalyzer
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoadTsFileAnalyzer.class);
    private static final LoadTsFileCostMetricsSet LOAD_TSFILE_COST_METRICS_SET = LoadTsFileCostMetricsSet.getInstance();
    private static final IClientManager<ConfigRegionId, ConfigNodeClient> CONFIG_NODE_CLIENT_MANAGER = ConfigNodeClientManager.getInstance();
    private static final int BATCH_FLUSH_TIME_SERIES_NUMBER;
    private static final long ANALYZE_SCHEMA_MEMORY_SIZE_IN_BYTES;
    private static final long FLUSH_ALIGNED_CACHE_MEMORY_SIZE_IN_BYTES;
    private final LoadTsFileStatement loadTsFileStatement;
    private final MPPQueryContext context;
    private final IPartitionFetcher partitionFetcher;
    private final ISchemaFetcher schemaFetcher;
    private final SchemaAutoCreatorAndVerifier schemaAutoCreatorAndVerifier;
    private final boolean isGeneratedByPipe;
    private final List<File> tsFiles;
    private final List<Boolean> isMiniTsFile;
    private boolean isMiniTsFileConverted = false;
    private final int databaseLevel;
    private final boolean isVerifySchema;
    private final boolean isAutoCreateDatabase;
    private final boolean isDeleteAfterLoad;
    private final boolean isConvertOnTypeMismatch;
    private final long tabletConversionThresholdBytes;

    LoadTsFileAnalyzer(LoadTsFileStatement loadTsFileStatement, MPPQueryContext context, IPartitionFetcher partitionFetcher, ISchemaFetcher schemaFetcher) {
        this.loadTsFileStatement = loadTsFileStatement;
        this.context = context;
        this.partitionFetcher = partitionFetcher;
        this.schemaFetcher = schemaFetcher;
        this.schemaAutoCreatorAndVerifier = new SchemaAutoCreatorAndVerifier();
        this.isGeneratedByPipe = loadTsFileStatement.isGeneratedByPipe();
        this.tsFiles = loadTsFileStatement.getTsFiles();
        this.isMiniTsFile = new ArrayList<Boolean>(Collections.nCopies(this.tsFiles.size(), false));
        this.databaseLevel = loadTsFileStatement.getDatabaseLevel();
        this.isVerifySchema = loadTsFileStatement.isVerifySchema();
        this.isAutoCreateDatabase = loadTsFileStatement.isAutoCreateDatabase();
        this.isDeleteAfterLoad = loadTsFileStatement.isDeleteAfterLoad();
        this.isConvertOnTypeMismatch = loadTsFileStatement.isConvertOnTypeMismatch();
        this.tabletConversionThresholdBytes = loadTsFileStatement.getTabletConversionThresholdBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Analysis analyzeFileByFile(Analysis analysis) {
        if (!this.checkBeforeAnalyzeFileByFile(analysis)) {
            return analysis;
        }
        try {
            if (!this.doAnalyzeFileByFile(analysis)) {
                return analysis;
            }
            long startTime = System.nanoTime();
            try {
                this.schemaAutoCreatorAndVerifier.flush();
            }
            finally {
                LOAD_TSFILE_COST_METRICS_SET.recordPhaseTimeCost("analysis", System.nanoTime() - startTime);
            }
        }
        catch (AuthException e) {
            return this.setFailAnalysisForAuthException(analysis, e);
        }
        catch (LoadAnalyzeTypeMismatchException e) {
            this.executeTabletConversionOnException(analysis, e);
            return analysis;
        }
        catch (Exception e) {
            String exceptionMessage = String.format("Auto create or verify schema error when executing statement %s. Detail: %s.", this.loadTsFileStatement, e.getMessage() == null ? e.getClass().getName() : e.getMessage());
            LOGGER.warn(exceptionMessage, (Throwable)e);
            analysis.setFinishQueryAfterAnalyze(true);
            analysis.setFailStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.LOAD_FILE_ERROR, (String)exceptionMessage));
            return analysis;
        }
        LOGGER.info("Load - Analysis Stage: all tsfiles have been analyzed.");
        if (this.reconstructStatementIfMiniFileConverted()) {
            analysis.setFinishQueryAfterAnalyze(true);
            analysis.setFailStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS));
            return analysis;
        }
        analysis.setStatement(this.loadTsFileStatement);
        return analysis;
    }

    private boolean checkBeforeAnalyzeFileByFile(Analysis analysis) {
        if (CommonDescriptor.getInstance().getConfig().isReadOnly()) {
            analysis.setFinishQueryAfterAnalyze(true);
            analysis.setFailStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SYSTEM_READ_ONLY, (String)"Current system mode is read only, does not support load file"));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doAnalyzeFileByFile(Analysis analysis) {
        int tsfileNum = this.loadTsFileStatement.getTsFiles().size();
        for (int i = 0; i < tsfileNum; ++i) {
            File tsFile = this.loadTsFileStatement.getTsFiles().get(i);
            if (tsFile.length() == 0L) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("TsFile {} is empty.", (Object)tsFile.getPath());
                }
                if (!LOGGER.isInfoEnabled()) continue;
                LOGGER.info("Load - Analysis Stage: {}/{} tsfiles have been analyzed, progress: {}%", new Object[]{i + 1, tsfileNum, String.format("%.3f", (double)(i + 1) * 100.0 / (double)tsfileNum)});
                continue;
            }
            long startTime = System.nanoTime();
            try {
                this.analyzeSingleTsFile(tsFile, i);
                if (!LOGGER.isInfoEnabled()) continue;
                LOGGER.info("Load - Analysis Stage: {}/{} tsfiles have been analyzed, progress: {}%", new Object[]{i + 1, tsfileNum, String.format("%.3f", (double)(i + 1) * 100.0 / (double)tsfileNum)});
                continue;
            }
            catch (AuthException e) {
                this.setFailAnalysisForAuthException(analysis, e);
                boolean bl = false;
                return bl;
            }
            catch (LoadAnalyzeTypeMismatchException e) {
                this.executeTabletConversionOnException(analysis, e);
                boolean bl = false;
                return bl;
            }
            catch (Exception e) {
                String exceptionMessage = String.format("The file %s is not a valid tsfile. Please check the input file. Detail: %s", tsFile.getPath(), e.getMessage() == null ? e.getClass().getName() : e.getMessage());
                LOGGER.warn(exceptionMessage, (Throwable)e);
                analysis.setFinishQueryAfterAnalyze(true);
                analysis.setFailStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.LOAD_FILE_ERROR, (String)exceptionMessage));
                boolean bl = false;
                return bl;
            }
            finally {
                LoadTsFileCostMetricsSet.getInstance().recordPhaseTimeCost("analysis", System.nanoTime() - startTime);
            }
        }
        return true;
    }

    private void analyzeSingleTsFile(File tsFile, int index) throws Exception {
        block10: {
            try (TsFileSequenceReader reader = new TsFileSequenceReader(tsFile.getAbsolutePath());){
                TsFileSequenceReaderTimeseriesMetadataIterator timeseriesMetadataIterator = new TsFileSequenceReaderTimeseriesMetadataIterator(reader, true, IoTDBDescriptor.getInstance().getConfig().getLoadTsFileAnalyzeSchemaBatchReadTimeSeriesMetadataCount());
                if (!timeseriesMetadataIterator.hasNext()) {
                    throw new LoadEmptyFileException(tsFile.getAbsolutePath());
                }
                if (0L <= this.tabletConversionThresholdBytes && tsFile.length() <= this.tabletConversionThresholdBytes && this.handleSingleMiniFile(index)) {
                    return;
                }
                this.doAnalyzeSingleFile(tsFile, reader, timeseriesMetadataIterator);
            }
            catch (LoadEmptyFileException loadEmptyFileException) {
                LOGGER.warn("Empty file detected, will skip loading this file: {}", (Object)tsFile.getAbsolutePath());
                if (!this.isDeleteAfterLoad) break block10;
                FileUtils.deleteQuietly((File)tsFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleSingleMiniFile(int i) throws FileNotFoundException {
        long startTime = System.nanoTime();
        try {
            LoadTsFileDataTypeConverter loadTsFileDataTypeConverter = new LoadTsFileDataTypeConverter(this.isGeneratedByPipe);
            TSStatus status = loadTsFileDataTypeConverter.convertForTreeModel(new LoadTsFileStatement(this.tsFiles.get(i).getPath()).setDeleteAfterLoad(this.isDeleteAfterLoad).setConvertOnTypeMismatch(this.isConvertOnTypeMismatch)).orElse(null);
            if (status == null || !loadTsFileDataTypeConverter.isSuccessful(status)) {
                LOGGER.warn("Load: Failed to convert mini tsfile {} to tablets from statement {}. Status: {}.", new Object[]{this.tsFiles.get(i).getPath(), this.loadTsFileStatement, status});
                boolean bl = false;
                return bl;
            }
            this.isMiniTsFile.set(i, Boolean.TRUE);
            this.isMiniTsFileConverted = true;
            this.loadTsFileStatement.addTsFileResource(null);
            this.loadTsFileStatement.addWritePointCount(0L);
            boolean bl = true;
            return bl;
        }
        finally {
            LOAD_TSFILE_COST_METRICS_SET.recordPhaseTimeCost("analysis_cast_tablets", System.nanoTime() - startTime);
        }
    }

    private void doAnalyzeSingleFile(File tsFile, TsFileSequenceReader reader, TsFileSequenceReaderTimeseriesMetadataIterator timeseriesMetadataIterator) throws IOException, LoadAnalyzeException, AuthException {
        boolean isAutoCreateSchemaOrVerifySchemaEnabled;
        TsFileResource tsFileResource = this.constructTsFileResource(reader, tsFile);
        long writePointCount = 0L;
        this.schemaAutoCreatorAndVerifier.setCurrentModificationsAndTimeIndex(tsFileResource);
        boolean bl = isAutoCreateSchemaOrVerifySchemaEnabled = IoTDBDescriptor.getInstance().getConfig().isAutoCreateSchemaEnabled() || this.isVerifySchema;
        while (timeseriesMetadataIterator.hasNext()) {
            Map device2TimeseriesMetadata = timeseriesMetadataIterator.next();
            if (isAutoCreateSchemaOrVerifySchemaEnabled) {
                this.schemaAutoCreatorAndVerifier.autoCreateAndVerify(reader, device2TimeseriesMetadata);
            }
            if (!tsFileResource.resourceFileExists()) {
                TsFileResourceUtils.updateTsFileResource(device2TimeseriesMetadata, tsFileResource);
            }
            writePointCount += this.getWritePointCount(device2TimeseriesMetadata);
        }
        if (isAutoCreateSchemaOrVerifySchemaEnabled) {
            this.schemaAutoCreatorAndVerifier.flushAndClearDeviceIsAlignedCacheIfNecessary();
        }
        TimestampPrecisionUtils.checkTimestampPrecision(tsFileResource.getFileEndTime());
        tsFileResource.setStatus(TsFileResourceStatus.NORMAL);
        this.loadTsFileStatement.addTsFileResource(tsFileResource);
        this.loadTsFileStatement.addWritePointCount(writePointCount);
    }

    private TsFileResource constructTsFileResource(TsFileSequenceReader reader, File tsFile) throws IOException {
        TsFileResource tsFileResource = new TsFileResource(tsFile);
        if (!tsFileResource.resourceFileExists()) {
            tsFileResource.updatePlanIndexes(reader.getMinPlanIndex());
            tsFileResource.updatePlanIndexes(reader.getMaxPlanIndex());
        } else {
            tsFileResource.deserialize();
            tsFileResource.setGeneratedByPipe(this.isGeneratedByPipe);
        }
        return tsFileResource;
    }

    private long getWritePointCount(Map<IDeviceID, List<TimeseriesMetadata>> device2TimeseriesMetadata) {
        return device2TimeseriesMetadata.values().stream().flatMap(Collection::stream).mapToLong(t -> t.getStatistics().getCount()).sum();
    }

    private boolean reconstructStatementIfMiniFileConverted() {
        if (!this.isMiniTsFileConverted) {
            return false;
        }
        return this.loadTsFileStatement.reconstructStatementIfMiniFileConverted(this.isMiniTsFile);
    }

    private Analysis setFailAnalysisForAuthException(Analysis analysis, AuthException e) {
        analysis.setFinishQueryAfterAnalyze(true);
        analysis.setFailStatus(RpcUtils.getStatus((TSStatusCode)e.getCode(), (String)e.getMessage()));
        return analysis;
    }

    private Analysis executeTabletConversionOnException(Analysis analysis, LoadAnalyzeException e) {
        TSStatus status;
        if (this.shouldSkipConversion(e)) {
            analysis.setFailStatus(new TSStatus(TSStatusCode.LOAD_FILE_ERROR.getStatusCode()).setMessage(e.getMessage()));
            analysis.setFinishQueryAfterAnalyze(true);
            return analysis;
        }
        LoadTsFileDataTypeConverter loadTsFileDataTypeConverter = new LoadTsFileDataTypeConverter(this.isGeneratedByPipe);
        TSStatus tSStatus = status = this.loadTsFileStatement.isConvertOnTypeMismatch() ? (TSStatus)loadTsFileDataTypeConverter.convertForTreeModel(this.loadTsFileStatement).orElse(null) : null;
        if (status == null) {
            LOGGER.warn("Load: Failed to convert to tablets from statement {}. Status is null.", (Object)this.loadTsFileStatement);
            analysis.setFailStatus(new TSStatus(TSStatusCode.LOAD_FILE_ERROR.getStatusCode()).setMessage(e.getMessage()));
        } else if (!loadTsFileDataTypeConverter.isSuccessful(status)) {
            LOGGER.warn("Load: Failed to convert to tablets from statement {}. Status: {}", (Object)this.loadTsFileStatement, (Object)status);
            analysis.setFailStatus(status);
        }
        analysis.setFinishQueryAfterAnalyze(true);
        analysis.setStatement(this.loadTsFileStatement);
        return analysis;
    }

    private boolean shouldSkipConversion(LoadAnalyzeException e) {
        return e instanceof LoadAnalyzeTypeMismatchException && !this.loadTsFileStatement.isConvertOnTypeMismatch();
    }

    @Override
    public void close() {
        this.schemaAutoCreatorAndVerifier.close();
    }

    static /* synthetic */ long access$1000() {
        return ANALYZE_SCHEMA_MEMORY_SIZE_IN_BYTES;
    }

    static {
        IoTDBConfig CONFIG = IoTDBDescriptor.getInstance().getConfig();
        BATCH_FLUSH_TIME_SERIES_NUMBER = CONFIG.getLoadTsFileAnalyzeSchemaBatchFlushTimeSeriesNumber();
        ANALYZE_SCHEMA_MEMORY_SIZE_IN_BYTES = CONFIG.getLoadTsFileAnalyzeSchemaMemorySizeInBytes() <= 0L ? (long)BATCH_FLUSH_TIME_SERIES_NUMBER << 10 : CONFIG.getLoadTsFileAnalyzeSchemaMemorySizeInBytes();
        FLUSH_ALIGNED_CACHE_MEMORY_SIZE_IN_BYTES = ANALYZE_SCHEMA_MEMORY_SIZE_IN_BYTES >> 1;
    }

    private final class SchemaAutoCreatorAndVerifier {
        private final LoadTsFileAnalyzeSchemaCache schemaCache = new LoadTsFileAnalyzeSchemaCache();

        private SchemaAutoCreatorAndVerifier() throws LoadRuntimeOutOfMemoryException {
        }

        public void setCurrentModificationsAndTimeIndex(TsFileResource resource) throws IOException {
            this.schemaCache.setCurrentModificationsAndTimeIndex(resource);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void autoCreateAndVerify(TsFileSequenceReader reader, Map<IDeviceID, List<TimeseriesMetadata>> device2TimeseriesMetadataList) throws IOException, AuthException, LoadAnalyzeTypeMismatchException {
            for (Map.Entry<IDeviceID, List<TimeseriesMetadata>> entry : device2TimeseriesMetadataList.entrySet()) {
                IDeviceID device = entry.getKey();
                try {
                    if (this.schemaCache.isDeviceDeletedByMods(device)) {
                        continue;
                    }
                }
                catch (IllegalPathException e) {
                    LOGGER.warn("Failed to check if device {} is deleted by mods. Will see it as not deleted.", (Object)device, (Object)e);
                }
                for (TimeseriesMetadata timeseriesMetadata : entry.getValue()) {
                    TSDataType dataType;
                    block17: {
                        try {
                            if (this.schemaCache.isTimeseriesDeletedByMods(device, timeseriesMetadata)) {
                                continue;
                            }
                        }
                        catch (IllegalPathException e) {
                            if (timeseriesMetadata.getMeasurementId().isEmpty()) break block17;
                            LOGGER.warn("Failed to check if device {}, timeseries {} is deleted by mods. Will see it as not deleted.", new Object[]{device, timeseriesMetadata.getMeasurementId(), e});
                        }
                    }
                    if (TSDataType.VECTOR.equals((Object)(dataType = timeseriesMetadata.getTsDataType()))) {
                        this.schemaCache.clearDeviceIsAlignedCacheIfNecessary();
                        this.schemaCache.addIsAlignedCache(device, true, false);
                    } else {
                        block18: {
                            long startTime = System.nanoTime();
                            try {
                                TSStatus status;
                                String userName = LoadTsFileAnalyzer.this.context.getSession().getUserName();
                                if (AuthorityChecker.SUPER_USER.equals(userName)) break block18;
                                try {
                                    List<PartialPath> paths = Collections.singletonList(new PartialPath(device, timeseriesMetadata.getMeasurementId()));
                                    status = AuthorityChecker.getTSStatus(AuthorityChecker.checkFullPathListPermission(userName, paths, PrivilegeType.WRITE_DATA.ordinal()), paths, PrivilegeType.WRITE_DATA);
                                }
                                catch (IllegalPathException e) {
                                    throw new RuntimeException(e);
                                }
                                if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                                    throw new AuthException(TSStatusCode.representOf((int)status.getCode()), status.getMessage());
                                }
                            }
                            finally {
                                PerformanceOverviewMetrics.getInstance().recordAuthCost(System.nanoTime() - startTime);
                            }
                        }
                        Pair compressionEncodingPair = reader.readTimeseriesCompressionTypeAndEncoding(timeseriesMetadata);
                        this.schemaCache.addTimeSeries(device, new MeasurementSchema(timeseriesMetadata.getMeasurementId(), dataType, (TSEncoding)compressionEncodingPair.getRight(), (CompressionType)compressionEncodingPair.getLeft()));
                        this.schemaCache.addIsAlignedCache(device, false, true);
                        if (!this.schemaCache.getDeviceIsAligned(device)) {
                            this.schemaCache.clearDeviceIsAlignedCacheIfNecessary();
                        }
                    }
                    if (!this.schemaCache.shouldFlushTimeSeries()) continue;
                    this.flush();
                }
            }
        }

        public void flushAndClearDeviceIsAlignedCacheIfNecessary() throws SemanticException {
            this.schemaCache.clearDeviceIsAlignedCacheIfNecessary();
        }

        public void flush() throws AuthException, LoadAnalyzeTypeMismatchException {
            this.doAutoCreateAndVerify();
            this.schemaCache.clearTimeSeries();
        }

        private void doAutoCreateAndVerify() throws SemanticException, AuthException, LoadAnalyzeTypeMismatchException {
            if (this.schemaCache.getDevice2TimeSeries().isEmpty()) {
                return;
            }
            try {
                if (LoadTsFileAnalyzer.this.isVerifySchema) {
                    this.makeSureNoDuplicatedMeasurementsInDevices();
                }
                if (LoadTsFileAnalyzer.this.isAutoCreateDatabase) {
                    this.autoCreateDatabase();
                }
                ISchemaTree schemaTree = this.autoCreateSchema();
                if (LoadTsFileAnalyzer.this.isVerifySchema) {
                    this.verifySchema(schemaTree);
                }
            }
            catch (AuthException | LoadAnalyzeTypeMismatchException e) {
                throw e;
            }
            catch (Exception e) {
                LOGGER.warn("Auto create or verify schema error.", (Throwable)e);
                throw new SemanticException(String.format("Auto create or verify schema error when executing statement %s.  Detail: %s.", LoadTsFileAnalyzer.this.loadTsFileStatement, e.getMessage()));
            }
        }

        private void makeSureNoDuplicatedMeasurementsInDevices() throws LoadAnalyzeException {
            for (Map.Entry<IDeviceID, Set<MeasurementSchema>> entry : this.schemaCache.getDevice2TimeSeries().entrySet()) {
                IDeviceID device = entry.getKey();
                HashMap<String, MeasurementSchema> measurement2Schema = new HashMap<String, MeasurementSchema>();
                for (MeasurementSchema timeseriesSchema : entry.getValue()) {
                    String measurement = timeseriesSchema.getMeasurementId();
                    if (measurement2Schema.containsKey(measurement)) {
                        throw new LoadAnalyzeException(String.format("Duplicated measurements %s in device %s.", measurement, device));
                    }
                    measurement2Schema.put(measurement, timeseriesSchema);
                }
            }
        }

        private void autoCreateDatabase() throws LoadAnalyzeException, LoadFileException, IllegalPathException, AuthException {
            int databasePrefixNodesLength = LoadTsFileAnalyzer.this.databaseLevel + 1;
            HashSet<PartialPath> databasesNeededToBeSet = new HashSet<PartialPath>();
            for (IDeviceID device : this.schemaCache.getDevice2TimeSeries().keySet()) {
                PartialPath devicePath = new PartialPath(device);
                String[] devicePrefixNodes = devicePath.getNodes();
                if (devicePrefixNodes.length < databasePrefixNodesLength) {
                    throw new LoadAnalyzeException(String.format("Database level %d is longer than device %s.", databasePrefixNodesLength, device));
                }
                String[] databasePrefixNodes = new String[databasePrefixNodesLength];
                System.arraycopy(devicePrefixNodes, 0, databasePrefixNodes, 0, databasePrefixNodesLength);
                databasesNeededToBeSet.add(new PartialPath(databasePrefixNodes));
            }
            if (this.schemaCache.getAlreadySetDatabases().isEmpty()) {
                try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
                    TGetDatabaseReq req = new TGetDatabaseReq(Arrays.asList(new ShowDatabaseStatement(new PartialPath(SqlConstant.getSingleRootArray())).getPathPattern().getNodes()), SchemaConstant.ALL_MATCH_SCOPE.serialize());
                    TShowDatabaseResp resp = configNodeClient.showDatabase(req);
                    for (String databaseName : resp.getDatabaseInfoMap().keySet()) {
                        this.schemaCache.addAlreadySetDatabase(new PartialPath(databaseName));
                    }
                }
                catch (IOException | ClientManagerException | TException e) {
                    throw new LoadFileException((Exception)e);
                }
            }
            databasesNeededToBeSet.removeAll(this.schemaCache.getAlreadySetDatabases());
            for (PartialPath databasePath : databasesNeededToBeSet) {
                DatabaseSchemaStatement statement = new DatabaseSchemaStatement(DatabaseSchemaStatement.DatabaseSchemaStatementType.CREATE);
                statement.setDatabasePath(databasePath);
                statement.setEnablePrintExceptionLog(false);
                this.executeSetDatabaseStatement(statement);
                this.schemaCache.addAlreadySetDatabase(databasePath);
            }
        }

        private void executeSetDatabaseStatement(Statement statement) throws LoadFileException, AuthException {
            TSStatus status = AuthorityChecker.checkAuthority(statement, LoadTsFileAnalyzer.this.context.getSession().getUserName());
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                throw new AuthException(TSStatusCode.representOf((int)status.getCode()), status.getMessage());
            }
            long queryId = SessionManager.getInstance().requestQueryId();
            ExecutionResult result = Coordinator.getInstance().executeForTreeModel(statement, queryId, null, "", LoadTsFileAnalyzer.this.partitionFetcher, LoadTsFileAnalyzer.this.schemaFetcher, IoTDBDescriptor.getInstance().getConfig().getQueryTimeoutThreshold(), false);
            if (result.status.code != TSStatusCode.SUCCESS_STATUS.getStatusCode() && result.status.code != TSStatusCode.DATABASE_ALREADY_EXISTS.getStatusCode()) {
                LOGGER.warn("Create database error, statement: {}, result status is: {}", (Object)statement, (Object)result.status);
                throw new LoadFileException(String.format("Create database error, statement: %s, result status is: %s", statement, result.status));
            }
        }

        private ISchemaTree autoCreateSchema() throws IllegalPathException {
            ArrayList<PartialPath> deviceList = new ArrayList<PartialPath>();
            ArrayList<String[]> measurementList = new ArrayList<String[]>();
            ArrayList<TSDataType[]> dataTypeList = new ArrayList<TSDataType[]>();
            ArrayList<TSEncoding[]> encodingsList = new ArrayList<TSEncoding[]>();
            ArrayList<CompressionType[]> compressionTypesList = new ArrayList<CompressionType[]>();
            ArrayList<Boolean> isAlignedList = new ArrayList<Boolean>();
            for (Map.Entry<IDeviceID, Set<MeasurementSchema>> entry : this.schemaCache.getDevice2TimeSeries().entrySet()) {
                int measurementSize = entry.getValue().size();
                String[] measurements = new String[measurementSize];
                TSDataType[] tsDataTypes = new TSDataType[measurementSize];
                TSEncoding[] encodings = new TSEncoding[measurementSize];
                CompressionType[] compressionTypes = new CompressionType[measurementSize];
                int index = 0;
                for (MeasurementSchema measurementSchema : entry.getValue()) {
                    measurements[index] = measurementSchema.getMeasurementId();
                    tsDataTypes[index] = measurementSchema.getType();
                    encodings[index] = measurementSchema.getEncodingType();
                    compressionTypes[index++] = measurementSchema.getCompressor();
                }
                deviceList.add(new PartialPath(entry.getKey()));
                measurementList.add(measurements);
                dataTypeList.add(tsDataTypes);
                encodingsList.add(encodings);
                compressionTypesList.add(compressionTypes);
                isAlignedList.add(this.schemaCache.getDeviceIsAligned(entry.getKey()));
            }
            return SchemaValidator.validate(LoadTsFileAnalyzer.this.schemaFetcher, deviceList, measurementList, dataTypeList, encodingsList, compressionTypesList, isAlignedList, LoadTsFileAnalyzer.this.context);
        }

        private void verifySchema(ISchemaTree schemaTree) throws LoadAnalyzeException, IllegalPathException, LoadAnalyzeTypeMismatchException {
            for (Map.Entry<IDeviceID, Set<MeasurementSchema>> entry : this.schemaCache.getDevice2TimeSeries().entrySet()) {
                boolean isAlignedInIoTDB;
                ArrayList tsfileTimeseriesSchemas;
                IDeviceID device = entry.getKey();
                DeviceSchemaInfo iotdbDeviceSchemaInfo = schemaTree.searchDeviceSchemaInfo(new PartialPath(device), (tsfileTimeseriesSchemas = new ArrayList(entry.getValue())).stream().map(MeasurementSchema::getMeasurementId).collect(Collectors.toList()));
                if (iotdbDeviceSchemaInfo == null) {
                    throw new LoadAnalyzeException(String.format("Device %s does not exist in IoTDB and can not be created. Please check weather auto-create-schema is enabled.", device));
                }
                boolean isAlignedInTsFile = this.schemaCache.getDeviceIsAligned(device);
                if (isAlignedInTsFile != (isAlignedInIoTDB = iotdbDeviceSchemaInfo.isAligned())) {
                    throw new LoadAnalyzeException(String.format("Device %s in TsFile is %s, but in IoTDB is %s.", device, isAlignedInTsFile ? "aligned" : "not aligned", isAlignedInIoTDB ? "aligned" : "not aligned"));
                }
                List<MeasurementSchema> iotdbTimeseriesSchemas = iotdbDeviceSchemaInfo.getMeasurementSchemaList();
                int n = iotdbTimeseriesSchemas.size();
                for (int i = 0; i < n; ++i) {
                    MeasurementSchema tsFileSchema = (MeasurementSchema)tsfileTimeseriesSchemas.get(i);
                    MeasurementSchema iotdbSchema = iotdbTimeseriesSchemas.get(i);
                    if (iotdbSchema == null) {
                        throw new LoadAnalyzeException(String.format("Measurement %s does not exist in IoTDB and can not be created. Please check weather auto-create-schema is enabled.", device + "." + tsfileTimeseriesSchemas.get(i)));
                    }
                    if (!tsFileSchema.getType().equals((Object)iotdbSchema.getType())) {
                        throw new LoadAnalyzeTypeMismatchException(String.format("Measurement %s%s%s datatype not match, TsFile: %s, IoTDB: %s", device, ".", iotdbSchema.getMeasurementId(), tsFileSchema.getType(), iotdbSchema.getType()));
                    }
                    if (LOGGER.isDebugEnabled() && !tsFileSchema.getEncodingType().equals((Object)iotdbSchema.getEncodingType())) {
                        LOGGER.debug("Encoding type not match, measurement: {}{}{}, TsFile encoding: {}, IoTDB encoding: {}", new Object[]{device, ".", iotdbSchema.getMeasurementId(), tsFileSchema.getEncodingType().name(), iotdbSchema.getEncodingType().name()});
                    }
                    if (!LOGGER.isDebugEnabled() || tsFileSchema.getCompressor().equals((Object)iotdbSchema.getCompressor())) continue;
                    LOGGER.debug("Compressor not match, measurement: {}{}{}, TsFile compressor: {}, IoTDB compressor: {}", new Object[]{device, ".", iotdbSchema.getMeasurementId(), tsFileSchema.getCompressor().name(), iotdbSchema.getCompressor().name()});
                }
            }
        }

        public void close() {
            this.schemaCache.close();
        }
    }

    private static class LoadTsFileAnalyzeSchemaCache {
        private final LoadTsFileMemoryBlock block = LoadTsFileMemoryManager.getInstance().allocateMemoryBlock(LoadTsFileAnalyzer.access$1000());
        private Map<IDeviceID, Set<MeasurementSchema>> currentBatchDevice2TimeSeriesSchemas = new HashMap<IDeviceID, Set<MeasurementSchema>>();
        private Map<IDeviceID, Boolean> tsFileDevice2IsAligned = new HashMap<IDeviceID, Boolean>();
        private Set<PartialPath> alreadySetDatabases = new HashSet<PartialPath>();
        private Collection<Modification> currentModifications = new ArrayList<Modification>();
        private ITimeIndex currentTimeIndex;
        private long batchDevice2TimeSeriesSchemasMemoryUsageSizeInBytes = 0L;
        private long tsFileDevice2IsAlignedMemoryUsageSizeInBytes = 0L;
        private long alreadySetDatabasesMemoryUsageSizeInBytes = 0L;
        private long currentModificationsMemoryUsageSizeInBytes = 0L;
        private long currentTimeIndexMemoryUsageSizeInBytes = 0L;
        private int currentBatchTimeSeriesCount = 0;

        public Map<IDeviceID, Set<MeasurementSchema>> getDevice2TimeSeries() {
            return this.currentBatchDevice2TimeSeriesSchemas;
        }

        public boolean getDeviceIsAligned(IDeviceID device) {
            if (!this.tsFileDevice2IsAligned.containsKey(device)) {
                LOGGER.warn("Device {} is not in the tsFileDevice2IsAligned cache {}.", (Object)device, this.tsFileDevice2IsAligned);
            }
            return this.tsFileDevice2IsAligned.get(device);
        }

        public Set<PartialPath> getAlreadySetDatabases() {
            return this.alreadySetDatabases;
        }

        public void addTimeSeries(IDeviceID device, MeasurementSchema measurementSchema) {
            long memoryUsageSizeInBytes = 0L;
            if (!this.currentBatchDevice2TimeSeriesSchemas.containsKey(device)) {
                memoryUsageSizeInBytes += (long)LoadTsFileAnalyzeSchemaCache.estimateStringSize(((PlainDeviceID)device).toStringID());
            }
            if (this.currentBatchDevice2TimeSeriesSchemas.computeIfAbsent(device, k -> new HashSet()).add(measurementSchema)) {
                memoryUsageSizeInBytes += (long)measurementSchema.serializedSize();
                ++this.currentBatchTimeSeriesCount;
            }
            if (memoryUsageSizeInBytes > 0L) {
                this.batchDevice2TimeSeriesSchemasMemoryUsageSizeInBytes += memoryUsageSizeInBytes;
                this.block.addMemoryUsage(memoryUsageSizeInBytes);
            }
        }

        public void addIsAlignedCache(IDeviceID device, boolean isAligned, boolean addIfAbsent) {
            long memoryUsageSizeInBytes = 0L;
            if (!this.tsFileDevice2IsAligned.containsKey(device)) {
                memoryUsageSizeInBytes += (long)LoadTsFileAnalyzeSchemaCache.estimateStringSize(((PlainDeviceID)device).toStringID());
            }
            if (addIfAbsent ? this.tsFileDevice2IsAligned.putIfAbsent(device, isAligned) == null : this.tsFileDevice2IsAligned.put(device, isAligned) == null) {
                ++memoryUsageSizeInBytes;
            }
            if (memoryUsageSizeInBytes > 0L) {
                this.tsFileDevice2IsAlignedMemoryUsageSizeInBytes += memoryUsageSizeInBytes;
                this.block.addMemoryUsage(memoryUsageSizeInBytes);
            }
        }

        public void setCurrentModificationsAndTimeIndex(TsFileResource resource) throws IOException {
            this.clearModificationsAndTimeIndex();
            this.currentModifications = resource.getModFile().getModifications();
            for (Modification modification : this.currentModifications) {
                this.currentModificationsMemoryUsageSizeInBytes += ((Deletion)modification).getSerializedSize();
            }
            this.block.addMemoryUsage(this.currentModificationsMemoryUsageSizeInBytes);
            if (resource.resourceFileExists()) {
                this.currentTimeIndex = resource.getTimeIndex();
                if (this.currentTimeIndex instanceof FileTimeIndex) {
                    this.currentTimeIndex = resource.buildDeviceTimeIndex();
                }
                this.currentTimeIndexMemoryUsageSizeInBytes = this.currentTimeIndex.calculateRamSize();
                this.block.addMemoryUsage(this.currentTimeIndexMemoryUsageSizeInBytes);
            }
        }

        public boolean isDeviceDeletedByMods(IDeviceID device) throws IllegalPathException {
            return ModificationUtils.isDeviceDeletedByMods(this.currentModifications, this.currentTimeIndex, device);
        }

        public boolean isTimeseriesDeletedByMods(IDeviceID device, TimeseriesMetadata timeseriesMetadata) throws IllegalPathException {
            return ModificationUtils.isTimeseriesDeletedByMods(this.currentModifications, device, timeseriesMetadata.getMeasurementId(), timeseriesMetadata.getStatistics().getStartTime(), timeseriesMetadata.getStatistics().getEndTime());
        }

        public void addAlreadySetDatabase(PartialPath database) {
            long memoryUsageSizeInBytes = 0L;
            if (this.alreadySetDatabases.add(database)) {
                memoryUsageSizeInBytes += (long)PartialPath.estimateSize((PartialPath)database);
            }
            if (memoryUsageSizeInBytes > 0L) {
                this.alreadySetDatabasesMemoryUsageSizeInBytes += memoryUsageSizeInBytes;
                this.block.addMemoryUsage(memoryUsageSizeInBytes);
            }
        }

        public boolean shouldFlushTimeSeries() {
            return !this.block.hasEnoughMemory() || this.currentBatchTimeSeriesCount >= BATCH_FLUSH_TIME_SERIES_NUMBER;
        }

        public boolean shouldFlushAlignedCache() {
            return this.tsFileDevice2IsAlignedMemoryUsageSizeInBytes >= FLUSH_ALIGNED_CACHE_MEMORY_SIZE_IN_BYTES;
        }

        public void clearTimeSeries() {
            this.currentBatchDevice2TimeSeriesSchemas.clear();
            this.block.reduceMemoryUsage(this.batchDevice2TimeSeriesSchemasMemoryUsageSizeInBytes);
            this.batchDevice2TimeSeriesSchemasMemoryUsageSizeInBytes = 0L;
            this.currentBatchTimeSeriesCount = 0;
        }

        public void clearModificationsAndTimeIndex() {
            this.currentModifications.clear();
            this.currentTimeIndex = null;
            this.block.reduceMemoryUsage(this.currentModificationsMemoryUsageSizeInBytes);
            this.block.reduceMemoryUsage(this.currentTimeIndexMemoryUsageSizeInBytes);
            this.currentModificationsMemoryUsageSizeInBytes = 0L;
            this.currentTimeIndexMemoryUsageSizeInBytes = 0L;
        }

        public void clearAlignedCache() {
            this.tsFileDevice2IsAligned.clear();
            this.block.reduceMemoryUsage(this.tsFileDevice2IsAlignedMemoryUsageSizeInBytes);
            this.tsFileDevice2IsAlignedMemoryUsageSizeInBytes = 0L;
        }

        public void clearDeviceIsAlignedCacheIfNecessary() {
            if (!this.shouldFlushAlignedCache()) {
                return;
            }
            long releaseMemoryInBytes = 0L;
            HashSet<IDeviceID> timeSeriesCacheKeySet = new HashSet<IDeviceID>(this.currentBatchDevice2TimeSeriesSchemas.keySet());
            Iterator<Map.Entry<IDeviceID, Boolean>> iterator = this.tsFileDevice2IsAligned.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<IDeviceID, Boolean> entry = iterator.next();
                if (timeSeriesCacheKeySet.contains(entry.getKey())) continue;
                releaseMemoryInBytes += (long)(LoadTsFileAnalyzeSchemaCache.estimateStringSize(((PlainDeviceID)entry.getKey()).toStringID()) + 1);
                iterator.remove();
            }
            if (releaseMemoryInBytes > 0L) {
                this.tsFileDevice2IsAlignedMemoryUsageSizeInBytes -= releaseMemoryInBytes;
                this.block.reduceMemoryUsage(releaseMemoryInBytes);
            }
        }

        private void clearDatabasesCache() {
            this.alreadySetDatabases.clear();
            this.block.reduceMemoryUsage(this.alreadySetDatabasesMemoryUsageSizeInBytes);
            this.alreadySetDatabasesMemoryUsageSizeInBytes = 0L;
        }

        public void close() {
            this.clearTimeSeries();
            this.clearModificationsAndTimeIndex();
            this.clearAlignedCache();
            this.clearDatabasesCache();
            this.block.close();
            this.currentBatchDevice2TimeSeriesSchemas = null;
            this.tsFileDevice2IsAligned = null;
            this.alreadySetDatabases = null;
        }

        private static int estimateStringSize(String string) {
            return string == null ? 0 : 32 + 2 * string.length();
        }
    }
}

