/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.read.filter.operator;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.exception.NotImplementedException;
import org.apache.tsfile.file.metadata.IMetadata;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.read.filter.basic.BinaryFilter;
import org.apache.tsfile.read.filter.basic.Filter;
import org.apache.tsfile.read.filter.basic.OperatorType;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public final class BinaryFilterOperators {
    private static final String CONSTANT_CANNOT_BE_NULL_MSG = "constant cannot be null";
    private static final String OPERATOR_TO_STRING_FORMAT = "measurements[%s] %s %s";

    private BinaryFilterOperators() {
    }

    private static class MatcherInput
    implements CharSequence {
        private final CharSequence value;
        private final AccessCount access;

        public MatcherInput(CharSequence value, AccessCount access) {
            this.value = value;
            this.access = access;
        }

        @Override
        public char charAt(int index) {
            this.access.check();
            return this.value.charAt(index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return new MatcherInput(this.value.subSequence(start, end), this.access);
        }

        @Override
        public int length() {
            return this.value.length();
        }

        @Override
        public String toString() {
            return this.value.toString();
        }
    }

    private static class AccessCount {
        private int count;
        private final int accessThreshold = TSFileDescriptor.getInstance().getConfig().getPatternMatchingThreshold();

        private AccessCount() {
        }

        public void check() throws IllegalStateException {
            if (this.count++ > this.accessThreshold) {
                throw new IllegalStateException("Pattern access threshold exceeded");
            }
        }
    }

    public static final class ValueNotRegexp
    extends ValueColumnPatternMatchFilter {
        public ValueNotRegexp(int measurementIndex, Pattern pattern) {
            super(measurementIndex, pattern);
        }

        public ValueNotRegexp(ByteBuffer buffer) {
            super(buffer);
        }

        @Override
        public boolean valueSatisfy(Object value) {
            return !this.pattern.matcher(new MatcherInput(value.toString(), new AccessCount())).find();
        }

        @Override
        public boolean valueSatisfy(Binary value) {
            return !this.pattern.matcher(new MatcherInput(value.toString(), new AccessCount())).find();
        }

        @Override
        protected boolean canSkip(Statistics<? extends Serializable> statistics) {
            return false;
        }

        @Override
        protected boolean allSatisfy(Statistics<? extends Serializable> statistics) {
            return false;
        }

        @Override
        public Filter reverse() {
            return new ValueRegexp(this.measurementIndex, this.pattern);
        }

        @Override
        public OperatorType getOperatorType() {
            return OperatorType.VALUE_NOT_REGEXP;
        }
    }

    public static final class ValueRegexp
    extends ValueColumnPatternMatchFilter {
        public ValueRegexp(int measurementIndex, Pattern pattern) {
            super(measurementIndex, pattern);
        }

        public ValueRegexp(ByteBuffer buffer) {
            super(buffer);
        }

        @Override
        public boolean valueSatisfy(Object value) {
            return this.pattern.matcher(new MatcherInput(value.toString(), new AccessCount())).find();
        }

        @Override
        public boolean valueSatisfy(Binary value) {
            return this.pattern.matcher(new MatcherInput(value.toString(), new AccessCount())).find();
        }

        @Override
        protected boolean canSkip(Statistics<? extends Serializable> statistics) {
            return false;
        }

        @Override
        protected boolean allSatisfy(Statistics<? extends Serializable> statistics) {
            return false;
        }

        @Override
        public Filter reverse() {
            return new ValueNotRegexp(this.measurementIndex, this.pattern);
        }

        @Override
        public OperatorType getOperatorType() {
            return OperatorType.VALUE_REGEXP;
        }
    }

    static abstract class ValueColumnPatternMatchFilter
    extends BinaryFilter {
        protected final Pattern pattern;

        protected ValueColumnPatternMatchFilter(int measurementIndex, Pattern pattern) {
            super(measurementIndex);
            this.pattern = Objects.requireNonNull(pattern, "pattern cannot be null");
        }

        protected ValueColumnPatternMatchFilter(ByteBuffer buffer) {
            super(buffer);
            this.pattern = Pattern.compile(Objects.requireNonNull(ReadWriteIOUtils.readString(buffer), "pattern cannot be null"));
        }

        @Override
        public void serialize(DataOutputStream outputStream) throws IOException {
            super.serialize(outputStream);
            ReadWriteIOUtils.write(this.pattern.pattern(), (OutputStream)outputStream);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ValueColumnPatternMatchFilter that = (ValueColumnPatternMatchFilter)o;
            return this.pattern.pattern().equals(that.pattern.pattern());
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.pattern.pattern());
        }

        public String toString() {
            return String.format(BinaryFilterOperators.OPERATOR_TO_STRING_FORMAT, this.measurementIndex, this.getOperatorType().getSymbol(), this.pattern);
        }
    }

    public static final class ValueNotIn
    extends ValueColumnSetFilter {
        public ValueNotIn(int measurementIndex, Set<Binary> candidates) {
            super(measurementIndex, candidates);
        }

        public ValueNotIn(ByteBuffer buffer) {
            super(buffer);
        }

        @Override
        public boolean valueSatisfy(Object value) {
            return !this.candidates.contains((Binary)value);
        }

        @Override
        public boolean valueSatisfy(Binary value) {
            return !this.candidates.contains(value);
        }

        @Override
        protected boolean canSkip(Statistics<? extends Serializable> statistics) {
            return false;
        }

        @Override
        protected boolean allSatisfy(Statistics<? extends Serializable> statistics) {
            return false;
        }

        @Override
        public Filter reverse() {
            return new ValueIn(this.measurementIndex, this.candidates);
        }

        @Override
        public OperatorType getOperatorType() {
            return OperatorType.VALUE_NOT_IN;
        }
    }

    public static final class ValueIn
    extends ValueColumnSetFilter {
        public ValueIn(int measurementIndex, Set<Binary> candidates) {
            super(measurementIndex, candidates);
        }

        public ValueIn(ByteBuffer buffer) {
            super(buffer);
        }

        @Override
        public boolean valueSatisfy(Object value) {
            return this.candidates.contains((Binary)value);
        }

        @Override
        public boolean valueSatisfy(Binary value) {
            return this.candidates.contains(value);
        }

        @Override
        public boolean canSkip(IMetadata metadata) {
            return false;
        }

        @Override
        protected boolean canSkip(Statistics<? extends Serializable> statistics) {
            throw new NotImplementedException();
        }

        @Override
        public boolean allSatisfy(IMetadata metadata) {
            return false;
        }

        @Override
        protected boolean allSatisfy(Statistics<? extends Serializable> statistics) {
            throw new NotImplementedException();
        }

        @Override
        public Filter reverse() {
            return new ValueNotIn(this.measurementIndex, this.candidates);
        }

        @Override
        public OperatorType getOperatorType() {
            return OperatorType.VALUE_IN;
        }

        private boolean isAllNulls(Statistics<? extends Serializable> statistics) {
            return statistics.getCount() == 0L;
        }

        private static boolean statisticsNotAvailable(Statistics<?> statistics) {
            return statistics.getType() == TSDataType.TEXT || statistics.getType() == TSDataType.BOOLEAN || statistics.getType() == TSDataType.BLOB || statistics.isEmpty();
        }
    }

    static abstract class ValueColumnSetFilter
    extends BinaryFilter {
        protected final Set<Binary> candidates;
        protected final Binary candidatesMin;
        protected final Binary candidatesMax;

        protected ValueColumnSetFilter(int measurementIndex, Set<Binary> candidates) {
            super(measurementIndex);
            this.candidates = candidates;
            Set filteredSet = candidates.stream().filter(Objects::nonNull).collect(Collectors.toSet());
            this.candidatesMin = !filteredSet.isEmpty() ? (Binary)Collections.min(filteredSet) : null;
            this.candidatesMax = !filteredSet.isEmpty() ? (Binary)Collections.max(filteredSet) : null;
        }

        protected ValueColumnSetFilter(ByteBuffer buffer) {
            super(buffer);
            boolean hasNull = ReadWriteIOUtils.readBoolean(buffer);
            this.candidates = ReadWriteIOUtils.readBinarySet(buffer);
            this.candidatesMin = !this.candidates.isEmpty() ? Collections.min(this.candidates) : null;
            Binary binary = this.candidatesMax = !this.candidates.isEmpty() ? Collections.max(this.candidates) : null;
            if (hasNull) {
                this.candidates.add(null);
            }
        }

        @Override
        public void serialize(DataOutputStream outputStream) throws IOException {
            super.serialize(outputStream);
            ReadWriteIOUtils.write((Boolean)this.candidates.contains(null), (OutputStream)outputStream);
            ReadWriteIOUtils.writeBinarySet(this.candidates, outputStream);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ValueColumnSetFilter that = (ValueColumnSetFilter)o;
            return this.candidates.equals(that.candidates);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.candidates);
        }

        public String toString() {
            return String.format(BinaryFilterOperators.OPERATOR_TO_STRING_FORMAT, this.measurementIndex, this.getOperatorType().getSymbol(), this.candidates);
        }
    }

    public static final class ValueNotBetweenAnd
    extends ValueColumnRangeFilter {
        public ValueNotBetweenAnd(int measurementIndex, Binary min, Binary max) {
            super(measurementIndex, min, max);
        }

        public ValueNotBetweenAnd(ByteBuffer buffer) {
            super(buffer);
        }

        @Override
        public boolean valueSatisfy(Object value) {
            return this.valueSatisfy((Binary)value);
        }

        @Override
        public boolean valueSatisfy(Binary value) {
            return this.min.compareTo(value) > 0 || this.max.compareTo(value) < 0;
        }

        @Override
        public boolean canSkip(Statistics<? extends Serializable> statistics) {
            return false;
        }

        @Override
        public boolean allSatisfy(Statistics<? extends Serializable> statistics) {
            return false;
        }

        @Override
        public Filter reverse() {
            return new ValueBetweenAnd(this.measurementIndex, this.min, this.max);
        }

        @Override
        public OperatorType getOperatorType() {
            return OperatorType.VALUE_NOT_BETWEEN_AND;
        }
    }

    public static final class ValueBetweenAnd
    extends ValueColumnRangeFilter {
        public ValueBetweenAnd(int measurementIndex, Binary min, Binary max) {
            super(measurementIndex, min, max);
        }

        public ValueBetweenAnd(ByteBuffer buffer) {
            super(buffer);
        }

        @Override
        public boolean valueSatisfy(Object value) {
            return this.valueSatisfy((Binary)value);
        }

        @Override
        public boolean valueSatisfy(Binary value) {
            return this.min.compareTo(value) <= 0 && this.max.compareTo(value) >= 0;
        }

        @Override
        public boolean canSkip(Statistics<? extends Serializable> statistics) {
            return false;
        }

        @Override
        public boolean allSatisfy(Statistics<? extends Serializable> statistics) {
            return false;
        }

        @Override
        public Filter reverse() {
            return new ValueNotBetweenAnd(this.measurementIndex, this.min, this.max);
        }

        @Override
        public OperatorType getOperatorType() {
            return OperatorType.VALUE_BETWEEN_AND;
        }
    }

    static abstract class ValueColumnRangeFilter
    extends BinaryFilter {
        protected final Binary min;
        protected final Binary max;

        protected ValueColumnRangeFilter(int measurementIndex, Binary min, Binary max) {
            super(measurementIndex);
            this.min = Objects.requireNonNull(min, "min cannot be null");
            this.max = Objects.requireNonNull(max, "max cannot be null");
        }

        protected ValueColumnRangeFilter(ByteBuffer buffer) {
            super(buffer);
            this.min = Objects.requireNonNull(ReadWriteIOUtils.readBinary(buffer), "min cannot be null");
            this.max = Objects.requireNonNull(ReadWriteIOUtils.readBinary(buffer), "max cannot be null");
        }

        @Override
        public void serialize(DataOutputStream outputStream) throws IOException {
            super.serialize(outputStream);
            ReadWriteIOUtils.write(this.min, (OutputStream)outputStream);
            ReadWriteIOUtils.write(this.max, (OutputStream)outputStream);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ValueColumnRangeFilter that = (ValueColumnRangeFilter)o;
            return this.min.equals((Object)that.min) && this.max.equals((Object)that.max);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.min, this.max);
        }

        public String toString() {
            return String.format("measurements[%s] %s %s AND %s", this.measurementIndex, this.getOperatorType().getSymbol(), this.min, this.max);
        }
    }

    public static final class ValueGtEq
    extends ValueColumnCompareFilter {
        public ValueGtEq(int measurementIndex, Binary constant) {
            super(measurementIndex, constant);
        }

        public ValueGtEq(ByteBuffer buffer) {
            super(buffer);
        }

        @Override
        public boolean valueSatisfy(Object value) {
            return this.valueSatisfy((Binary)value);
        }

        @Override
        public boolean valueSatisfy(Binary value) {
            return this.constant.compareTo(value) <= 0;
        }

        @Override
        public boolean canSkip(Statistics<? extends Serializable> statistics) {
            return false;
        }

        @Override
        public boolean allSatisfy(Statistics<? extends Serializable> statistics) {
            return false;
        }

        @Override
        public Filter reverse() {
            return new ValueLt(this.measurementIndex, this.constant);
        }

        @Override
        public OperatorType getOperatorType() {
            return OperatorType.VALUE_GTEQ;
        }
    }

    public static final class ValueGt
    extends ValueColumnCompareFilter {
        public ValueGt(int measurementIndex, Binary constant) {
            super(measurementIndex, constant);
        }

        public ValueGt(ByteBuffer buffer) {
            super(buffer);
        }

        @Override
        public boolean valueSatisfy(Object value) {
            return this.valueSatisfy((Binary)value);
        }

        @Override
        public boolean valueSatisfy(Binary value) {
            return this.constant.compareTo(value) < 0;
        }

        @Override
        public boolean canSkip(Statistics<? extends Serializable> statistics) {
            return false;
        }

        @Override
        public boolean allSatisfy(Statistics<? extends Serializable> statistics) {
            return false;
        }

        @Override
        public Filter reverse() {
            return new ValueLtEq(this.measurementIndex, this.constant);
        }

        @Override
        public OperatorType getOperatorType() {
            return OperatorType.VALUE_GT;
        }
    }

    public static final class ValueLtEq
    extends ValueColumnCompareFilter {
        public ValueLtEq(int measurementIndex, Binary constant) {
            super(measurementIndex, constant);
        }

        public ValueLtEq(ByteBuffer buffer) {
            super(buffer);
        }

        @Override
        public boolean valueSatisfy(Object value) {
            return this.valueSatisfy((Binary)value);
        }

        @Override
        public boolean valueSatisfy(Binary value) {
            return this.constant.compareTo(value) >= 0;
        }

        @Override
        public boolean canSkip(Statistics<? extends Serializable> statistics) {
            return false;
        }

        @Override
        public boolean allSatisfy(Statistics<? extends Serializable> statistics) {
            return false;
        }

        @Override
        public Filter reverse() {
            return new ValueGt(this.measurementIndex, this.constant);
        }

        @Override
        public OperatorType getOperatorType() {
            return OperatorType.VALUE_LTEQ;
        }
    }

    public static final class ValueLt
    extends ValueColumnCompareFilter {
        public ValueLt(int measurementIndex, Binary constant) {
            super(measurementIndex, constant);
        }

        public ValueLt(ByteBuffer buffer) {
            super(buffer);
        }

        @Override
        public boolean valueSatisfy(Object value) {
            return this.valueSatisfy((Binary)value);
        }

        @Override
        public boolean valueSatisfy(Binary value) {
            return this.constant.compareTo(value) > 0;
        }

        @Override
        public boolean canSkip(Statistics<? extends Serializable> statistics) {
            return false;
        }

        @Override
        public boolean allSatisfy(Statistics<? extends Serializable> statistics) {
            return false;
        }

        @Override
        public Filter reverse() {
            return new ValueGtEq(this.measurementIndex, this.constant);
        }

        @Override
        public OperatorType getOperatorType() {
            return OperatorType.VALUE_LT;
        }
    }

    public static final class ValueNotEq
    extends ValueColumnCompareFilter {
        public ValueNotEq(int measurementIndex, Binary constant) {
            super(measurementIndex, constant);
        }

        public ValueNotEq(ByteBuffer buffer) {
            super(buffer);
        }

        @Override
        public boolean valueSatisfy(Object value) {
            return this.valueSatisfy((Binary)value);
        }

        @Override
        public boolean valueSatisfy(Binary value) {
            return !this.constant.equals((Object)value);
        }

        @Override
        public boolean canSkip(Statistics<? extends Serializable> statistics) {
            return false;
        }

        @Override
        public boolean allSatisfy(Statistics<? extends Serializable> statistics) {
            return false;
        }

        @Override
        public Filter reverse() {
            return new ValueEq(this.measurementIndex, this.constant);
        }

        @Override
        public OperatorType getOperatorType() {
            return OperatorType.VALUE_NEQ;
        }
    }

    public static final class ValueEq
    extends ValueColumnCompareFilter {
        public ValueEq(int measurementIndex, Binary constant) {
            super(measurementIndex, constant);
        }

        public ValueEq(ByteBuffer buffer) {
            super(buffer);
        }

        @Override
        public boolean valueSatisfy(Object value) {
            return this.valueSatisfy((Binary)value);
        }

        @Override
        public boolean valueSatisfy(Binary value) {
            return this.constant.equals((Object)value);
        }

        @Override
        public boolean canSkip(Statistics<? extends Serializable> statistics) {
            return false;
        }

        @Override
        public boolean allSatisfy(Statistics<? extends Serializable> statistics) {
            return false;
        }

        @Override
        public Filter reverse() {
            return new ValueNotEq(this.measurementIndex, this.constant);
        }

        @Override
        public OperatorType getOperatorType() {
            return OperatorType.VALUE_EQ;
        }
    }

    static abstract class ValueColumnCompareFilter
    extends BinaryFilter {
        protected final Binary constant;

        protected ValueColumnCompareFilter(int measurementIndex, Binary constant) {
            super(measurementIndex);
            this.constant = Objects.requireNonNull(constant, BinaryFilterOperators.CONSTANT_CANNOT_BE_NULL_MSG);
        }

        protected ValueColumnCompareFilter(ByteBuffer buffer) {
            super(buffer);
            this.constant = Objects.requireNonNull(ReadWriteIOUtils.readBinary(buffer), BinaryFilterOperators.CONSTANT_CANNOT_BE_NULL_MSG);
        }

        @Override
        public void serialize(DataOutputStream outputStream) throws IOException {
            super.serialize(outputStream);
            ReadWriteIOUtils.write(this.constant, (OutputStream)outputStream);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ValueColumnCompareFilter that = (ValueColumnCompareFilter)o;
            return Objects.equals(this.constant, that.constant);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.constant);
        }

        public String toString() {
            return String.format(BinaryFilterOperators.OPERATOR_TO_STRING_FORMAT, this.measurementIndex, this.getOperatorType().getSymbol(), this.constant);
        }
    }
}

