/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaResponseMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseResult;
import org.eclipse.milo.opcua.stack.core.types.structured.ResponseHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class BrowseNextResponse
extends Structure
implements UaResponseMessage {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=534");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=536");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=535");
    public static final ExpandedNodeId JSON_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=15187");
    private final ResponseHeader responseHeader;
    private final BrowseResult[] results;
    private final DiagnosticInfo[] diagnosticInfos;

    public BrowseNextResponse(ResponseHeader responseHeader, BrowseResult[] results, DiagnosticInfo[] diagnosticInfos) {
        this.responseHeader = responseHeader;
        this.results = results;
        this.diagnosticInfos = diagnosticInfos;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public ResponseHeader getResponseHeader() {
        return this.responseHeader;
    }

    public BrowseResult[] getResults() {
        return this.results;
    }

    public DiagnosticInfo[] getDiagnosticInfos() {
        return this.diagnosticInfos;
    }

    protected BrowseNextResponse(BrowseNextResponseBuilder<?, ?> b) {
        super(b);
        this.responseHeader = ((BrowseNextResponseBuilder)b).responseHeader;
        this.results = ((BrowseNextResponseBuilder)b).results;
        this.diagnosticInfos = ((BrowseNextResponseBuilder)b).diagnosticInfos;
    }

    public static BrowseNextResponseBuilder<?, ?> builder() {
        return new BrowseNextResponseBuilderImpl();
    }

    public BrowseNextResponseBuilder<?, ?> toBuilder() {
        return new BrowseNextResponseBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BrowseNextResponse)) {
            return false;
        }
        BrowseNextResponse other = (BrowseNextResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ResponseHeader this$responseHeader = this.getResponseHeader();
        ResponseHeader other$responseHeader = other.getResponseHeader();
        if (this$responseHeader == null ? other$responseHeader != null : !((Object)this$responseHeader).equals(other$responseHeader)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getResults(), other.getResults())) {
            return false;
        }
        return Arrays.deepEquals(this.getDiagnosticInfos(), other.getDiagnosticInfos());
    }

    protected boolean canEqual(Object other) {
        return other instanceof BrowseNextResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ResponseHeader $responseHeader = this.getResponseHeader();
        result = result * 59 + ($responseHeader == null ? 43 : ((Object)$responseHeader).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getResults());
        result = result * 59 + Arrays.deepHashCode(this.getDiagnosticInfos());
        return result;
    }

    @Override
    public String toString() {
        return "BrowseNextResponse(responseHeader=" + this.getResponseHeader() + ", results=" + Arrays.deepToString(this.getResults()) + ", diagnosticInfos=" + Arrays.deepToString(this.getDiagnosticInfos()) + ")";
    }

    private static final class BrowseNextResponseBuilderImpl
    extends BrowseNextResponseBuilder<BrowseNextResponse, BrowseNextResponseBuilderImpl> {
        private BrowseNextResponseBuilderImpl() {
        }

        @Override
        protected BrowseNextResponseBuilderImpl self() {
            return this;
        }

        @Override
        public BrowseNextResponse build() {
            return new BrowseNextResponse(this);
        }
    }

    public static abstract class BrowseNextResponseBuilder<C extends BrowseNextResponse, B extends BrowseNextResponseBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private ResponseHeader responseHeader;
        private BrowseResult[] results;
        private DiagnosticInfo[] diagnosticInfos;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            BrowseNextResponseBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(BrowseNextResponse instance, BrowseNextResponseBuilder<?, ?> b) {
            b.responseHeader(instance.responseHeader);
            b.results(instance.results);
            b.diagnosticInfos(instance.diagnosticInfos);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B responseHeader(ResponseHeader responseHeader) {
            this.responseHeader = responseHeader;
            return (B)this.self();
        }

        public B results(BrowseResult[] results) {
            this.results = results;
            return (B)this.self();
        }

        public B diagnosticInfos(DiagnosticInfo[] diagnosticInfos) {
            this.diagnosticInfos = diagnosticInfos;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "BrowseNextResponse.BrowseNextResponseBuilder(super=" + super.toString() + ", responseHeader=" + this.responseHeader + ", results=" + Arrays.deepToString(this.results) + ", diagnosticInfos=" + Arrays.deepToString(this.diagnosticInfos) + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<BrowseNextResponse> {
        @Override
        public Class<BrowseNextResponse> getType() {
            return BrowseNextResponse.class;
        }

        @Override
        public BrowseNextResponse decode(SerializationContext context, UaDecoder decoder) {
            ResponseHeader responseHeader = (ResponseHeader)decoder.readStruct("ResponseHeader", ResponseHeader.TYPE_ID);
            BrowseResult[] results = (BrowseResult[])decoder.readStructArray("Results", BrowseResult.TYPE_ID);
            DiagnosticInfo[] diagnosticInfos = decoder.readDiagnosticInfoArray("DiagnosticInfos");
            return new BrowseNextResponse(responseHeader, results, diagnosticInfos);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, BrowseNextResponse value) {
            encoder.writeStruct("ResponseHeader", (Object)value.getResponseHeader(), ResponseHeader.TYPE_ID);
            encoder.writeStructArray("Results", (Object[])value.getResults(), BrowseResult.TYPE_ID);
            encoder.writeDiagnosticInfoArray("DiagnosticInfos", value.getDiagnosticInfos());
        }
    }
}

