/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.subscription.broker;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.commons.pipe.agent.task.connection.UnboundedBlockingPendingQueue;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.commons.subscription.config.SubscriptionConfig;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeRawTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tsfile.PipeTsFileInsertionEvent;
import org.apache.iotdb.db.subscription.broker.SubscriptionBlockingPendingQueue;
import org.apache.iotdb.pipe.api.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsFileDeduplicationBlockingPendingQueue
extends SubscriptionBlockingPendingQueue {
    private static final Logger LOGGER = LoggerFactory.getLogger(TsFileDeduplicationBlockingPendingQueue.class);
    private final Cache<Integer, Boolean> hashCodeToIsGeneratedByHistoricalExtractor = Caffeine.newBuilder().expireAfterAccess(SubscriptionConfig.getInstance().getSubscriptionTsFileDeduplicationWindowSeconds(), TimeUnit.SECONDS).build();

    public TsFileDeduplicationBlockingPendingQueue(UnboundedBlockingPendingQueue<Event> inputPendingQueue) {
        super(inputPendingQueue);
    }

    @Override
    public Event waitedPoll() {
        return this.filter(this.inputPendingQueue.waitedPoll());
    }

    @Override
    public Event peek() {
        return this.inputPendingQueue.peek();
    }

    @Override
    public void directOffer(Event event) {
        this.inputPendingQueue.directOffer(event);
    }

    private synchronized Event filter(Event event) {
        PipeTsFileInsertionEvent pipeTsFileInsertionEvent;
        PipeRawTabletInsertionEvent pipeRawTabletInsertionEvent;
        EnrichedEvent sourceEvent;
        if (Objects.isNull(event)) {
            return null;
        }
        if (event instanceof PipeRawTabletInsertionEvent && (sourceEvent = (pipeRawTabletInsertionEvent = (PipeRawTabletInsertionEvent)event).getSourceEvent()) instanceof PipeTsFileInsertionEvent && this.isDuplicated((PipeTsFileInsertionEvent)sourceEvent)) {
            pipeRawTabletInsertionEvent.decreaseReferenceCount(TsFileDeduplicationBlockingPendingQueue.class.getName(), true);
            return null;
        }
        if (event instanceof PipeTsFileInsertionEvent && this.isDuplicated(pipeTsFileInsertionEvent = (PipeTsFileInsertionEvent)event)) {
            pipeTsFileInsertionEvent.decreaseReferenceCount(TsFileDeduplicationBlockingPendingQueue.class.getName(), true);
            return null;
        }
        return event;
    }

    private boolean isDuplicated(PipeTsFileInsertionEvent event) {
        int hashCode = event.getTsFile().hashCode();
        boolean isGeneratedByHistoricalExtractor = event.isGeneratedByHistoricalExtractor();
        Boolean existedIsGeneratedByHistoricalExtractor = (Boolean)this.hashCodeToIsGeneratedByHistoricalExtractor.getIfPresent((Object)hashCode);
        if (Objects.isNull(existedIsGeneratedByHistoricalExtractor)) {
            this.hashCodeToIsGeneratedByHistoricalExtractor.put((Object)hashCode, (Object)isGeneratedByHistoricalExtractor);
            return false;
        }
        if (Objects.equals(existedIsGeneratedByHistoricalExtractor, isGeneratedByHistoricalExtractor)) {
            return false;
        }
        LOGGER.info("Subscription: Detect duplicated PipeTsFileInsertionEvent {}, commit it directly", (Object)event.coreReportMessage());
        return true;
    }
}

