/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Metric {
    private static final Logger logger = LoggerFactory.getLogger(Metric.class);
    private static final int DEFAULT_PRINT_RATE = 1000;
    public String stepName;
    public long invokeCount;
    public long totalTime;
    public long lastCycleTime;
    public int printRate;

    public Metric(String stepName) {
        this(stepName, 1000);
    }

    public Metric(String stepName, int printRate) {
        this.stepName = stepName;
        this.invokeCount = 0L;
        this.totalTime = 0L;
        this.lastCycleTime = 0L;
        this.printRate = printRate;
    }

    public void trace(long startTime, long endTime) {
        ++this.invokeCount;
        this.totalTime += endTime - startTime;
    }

    public void tryPrint() {
        if (this.invokeCount % (long)this.printRate == 0L) {
            logger.info(String.format("step metrics [%d]-[%s] - Total: %d, SUM: %.2fms, AVG: %fms, Last%dAVG: %fms", Thread.currentThread().getId(), this.stepName, this.invokeCount, (double)this.totalTime * 1.0 / 1000000.0, (double)this.totalTime * 1.0 / 1000000.0 / (double)this.invokeCount, this.printRate, ((double)this.totalTime * 1.0 - (double)this.lastCycleTime) / 1000000.0 / (double)this.printRate));
            this.lastCycleTime = this.totalTime;
        }
    }
}

