/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tool.schema;

import java.io.File;
import java.util.ArrayList;
import org.apache.iotdb.cli.utils.IoTPrinter;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.tool.data.ImportDataScanTool;
import org.apache.iotdb.tool.schema.AbstractSchemaTool;

public abstract class AbstractImportSchema
extends AbstractSchemaTool
implements Runnable {
    private static final IoTPrinter ioTPrinter = new IoTPrinter(System.out);

    public abstract void init() throws InterruptedException, IoTDBConnectionException, StatementExecutionException;

    @Override
    public void run() {
        try {
            String filePath;
            while ((filePath = ImportDataScanTool.pollFromQueue()) != null) {
                File file = new File(filePath);
                if (!sqlDialectTree.booleanValue() && file.getName().endsWith("sql")) {
                    this.importSchemaFromSqlFile(file);
                    continue;
                }
                if (sqlDialectTree.booleanValue() && file.getName().endsWith("csv")) {
                    this.importSchemaFromCsvFile(file);
                    continue;
                }
                ioTPrinter.println(file.getName() + " : The file name must end with \"csv\" when sql_dialect tree or \"sql\" when sql_dialect table!");
            }
        }
        catch (Exception e) {
            ioTPrinter.println("Unexpected error occurred: " + e.getMessage());
        }
    }

    protected abstract Runnable getAsyncImportRunnable();

    public static void init(AbstractImportSchema instance) {
        instance.new ThreadManager().asyncImportSchemaFiles();
    }

    protected abstract void importSchemaFromSqlFile(File var1);

    protected abstract void importSchemaFromCsvFile(File var1);

    protected void processSuccessFile() {
        loadFileSuccessfulNum.increment();
    }

    protected class ThreadManager {
        protected ThreadManager() {
        }

        public void asyncImportSchemaFiles() {
            ArrayList<Thread> list = new ArrayList<Thread>(AbstractSchemaTool.threadNum);
            for (int i = 0; i < AbstractSchemaTool.threadNum; ++i) {
                Thread thread2 = new Thread(AbstractImportSchema.this.getAsyncImportRunnable());
                thread2.start();
                list.add(thread2);
            }
            list.forEach(thread -> {
                try {
                    thread.join();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    ioTPrinter.println("ImportData thread join interrupted: " + e.getMessage());
                }
            });
            ioTPrinter.println("Import completely!");
        }
    }
}

