/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.subscription.meta.subscription;

import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.iotdb.commons.subscription.meta.topic.TopicMeta;

public class SubscriptionMeta {
    private TopicMeta topicMeta;
    private String consumerGroupId;
    private Set<String> consumerIds;
    private Long creationTime;

    private SubscriptionMeta() {
    }

    public SubscriptionMeta(TopicMeta topicMeta, String consumerGroupId, Set<String> consumerIds, Long creationTime) {
        this.topicMeta = topicMeta;
        this.consumerGroupId = consumerGroupId;
        this.consumerIds = consumerIds;
        this.creationTime = creationTime;
    }

    public TopicMeta getTopicMeta() {
        return this.topicMeta;
    }

    public String getConsumerGroupId() {
        return this.consumerGroupId;
    }

    public Set<String> getConsumerIds() {
        return this.consumerIds;
    }

    public Optional<Long> getCreationTime() {
        return Objects.nonNull(this.creationTime) ? Optional.of(this.creationTime) : Optional.empty();
    }

    public String getSubscriptionId() {
        StringBuilder subscriptionId = new StringBuilder(this.topicMeta.getTopicName() + "_" + this.consumerGroupId);
        this.getCreationTime().ifPresent(creationTime -> subscriptionId.append("_").append(creationTime));
        return subscriptionId.toString();
    }
}

