/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteReferencesItem;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class DeleteReferencesRequest
extends Structure
implements UaRequestMessage {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=504");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=506");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=505");
    private final RequestHeader requestHeader;
    private final DeleteReferencesItem[] referencesToDelete;

    public DeleteReferencesRequest(RequestHeader requestHeader, DeleteReferencesItem[] referencesToDelete) {
        this.requestHeader = requestHeader;
        this.referencesToDelete = referencesToDelete;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    public DeleteReferencesItem[] getReferencesToDelete() {
        return this.referencesToDelete;
    }

    protected DeleteReferencesRequest(DeleteReferencesRequestBuilder<?, ?> b) {
        super(b);
        this.requestHeader = ((DeleteReferencesRequestBuilder)b).requestHeader;
        this.referencesToDelete = ((DeleteReferencesRequestBuilder)b).referencesToDelete;
    }

    public static DeleteReferencesRequestBuilder<?, ?> builder() {
        return new DeleteReferencesRequestBuilderImpl();
    }

    public DeleteReferencesRequestBuilder<?, ?> toBuilder() {
        return new DeleteReferencesRequestBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeleteReferencesRequest)) {
            return false;
        }
        DeleteReferencesRequest other = (DeleteReferencesRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RequestHeader this$requestHeader = this.getRequestHeader();
        RequestHeader other$requestHeader = other.getRequestHeader();
        if (this$requestHeader == null ? other$requestHeader != null : !((Object)this$requestHeader).equals(other$requestHeader)) {
            return false;
        }
        return Arrays.deepEquals(this.getReferencesToDelete(), other.getReferencesToDelete());
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeleteReferencesRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RequestHeader $requestHeader = this.getRequestHeader();
        result = result * 59 + ($requestHeader == null ? 43 : ((Object)$requestHeader).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getReferencesToDelete());
        return result;
    }

    @Override
    public String toString() {
        return "DeleteReferencesRequest(requestHeader=" + this.getRequestHeader() + ", referencesToDelete=" + Arrays.deepToString(this.getReferencesToDelete()) + ")";
    }

    private static final class DeleteReferencesRequestBuilderImpl
    extends DeleteReferencesRequestBuilder<DeleteReferencesRequest, DeleteReferencesRequestBuilderImpl> {
        private DeleteReferencesRequestBuilderImpl() {
        }

        @Override
        protected DeleteReferencesRequestBuilderImpl self() {
            return this;
        }

        @Override
        public DeleteReferencesRequest build() {
            return new DeleteReferencesRequest(this);
        }
    }

    public static abstract class DeleteReferencesRequestBuilder<C extends DeleteReferencesRequest, B extends DeleteReferencesRequestBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private RequestHeader requestHeader;
        private DeleteReferencesItem[] referencesToDelete;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            DeleteReferencesRequestBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(DeleteReferencesRequest instance, DeleteReferencesRequestBuilder<?, ?> b) {
            b.requestHeader(instance.requestHeader);
            b.referencesToDelete(instance.referencesToDelete);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B requestHeader(RequestHeader requestHeader) {
            this.requestHeader = requestHeader;
            return (B)this.self();
        }

        public B referencesToDelete(DeleteReferencesItem[] referencesToDelete) {
            this.referencesToDelete = referencesToDelete;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "DeleteReferencesRequest.DeleteReferencesRequestBuilder(super=" + super.toString() + ", requestHeader=" + this.requestHeader + ", referencesToDelete=" + Arrays.deepToString(this.referencesToDelete) + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<DeleteReferencesRequest> {
        @Override
        public Class<DeleteReferencesRequest> getType() {
            return DeleteReferencesRequest.class;
        }

        @Override
        public DeleteReferencesRequest decode(SerializationContext context, UaDecoder decoder) {
            RequestHeader requestHeader = (RequestHeader)decoder.readStruct("RequestHeader", RequestHeader.TYPE_ID);
            DeleteReferencesItem[] referencesToDelete = (DeleteReferencesItem[])decoder.readStructArray("ReferencesToDelete", DeleteReferencesItem.TYPE_ID);
            return new DeleteReferencesRequest(requestHeader, referencesToDelete);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, DeleteReferencesRequest value) {
            encoder.writeStruct("RequestHeader", (Object)value.getRequestHeader(), RequestHeader.TYPE_ID);
            encoder.writeStructArray("ReferencesToDelete", (Object[])value.getReferencesToDelete(), DeleteReferencesItem.TYPE_ID);
        }
    }
}

