/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.encoding.fire;

import org.apache.tsfile.encoding.fire.Fire;

public class LongFire
extends Fire<Long> {
    public LongFire(int learning_rate) {
        super(learning_rate);
        this.bitWidth = 16;
        this.accumulator = 0;
        this.delta = Long.valueOf(0L);
    }

    public void reset() {
        this.accumulator = 0;
        this.delta = Long.valueOf(0L);
    }

    @Override
    public Long predict(Long value) {
        long alpha = this.accumulator >> this.learnShift;
        long diff = alpha * (Long)this.delta >> this.bitWidth;
        return value + diff;
    }

    @Override
    public void train(Long pre, Long val, Long err) {
        long gradient = err > 0L ? -((Long)this.delta).longValue() : (Long)this.delta;
        this.accumulator = (int)((long)this.accumulator - gradient);
        this.delta = Long.valueOf(val - pre);
    }
}

