/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.hash;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import java.util.Arrays;
import java.util.List;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.UpdateMemory;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.hash.FlatHash;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.hash.GroupByHash;
import org.apache.iotdb.db.queryengine.plan.relational.utils.TypeUtil;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.read.common.type.Type;
import org.apache.tsfile.utils.RamUsageEstimator;

public class FlatGroupByHash
implements GroupByHash {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(FlatGroupByHash.class);
    private static final int BATCH_SIZE = 1024;
    private static final double SMALL_DICTIONARIES_MAX_CARDINALITY_RATIO = 0.25;
    private final FlatHash flatHash;
    private final int groupByChannelCount;
    private final boolean hasPrecomputedHash;
    private long currentPageSizeInBytes;
    private final Column[] currentColumns;
    private final ColumnBuilder[] currentColumnBuilders;
    private long[] currentHashes;

    public FlatGroupByHash(List<Type> hashTypes, boolean hasPrecomputedHash, int expectedSize, UpdateMemory checkMemoryReservation) {
        this.flatHash = new FlatHash(TypeUtil.getFlatHashStrategy(hashTypes), hasPrecomputedHash, expectedSize, checkMemoryReservation);
        this.groupByChannelCount = hashTypes.size();
        this.hasPrecomputedHash = hasPrecomputedHash;
        Preconditions.checkArgument((expectedSize > 0 ? 1 : 0) != 0, (Object)"expectedSize must be greater than zero");
        int totalChannels = hashTypes.size() + (hasPrecomputedHash ? 1 : 0);
        this.currentColumns = new Column[totalChannels];
        this.currentColumnBuilders = new ColumnBuilder[totalChannels];
    }

    public int getPhysicalPosition(int groupId) {
        return this.flatHash.getPhysicalPosition(groupId);
    }

    @Override
    public long getRawHash(int groupId) {
        return this.flatHash.hashPosition(groupId);
    }

    @Override
    public long getEstimatedSize() {
        return FlatHash.sumExact(INSTANCE_SIZE, this.flatHash.getEstimatedSize(), this.currentPageSizeInBytes, RamUsageEstimator.sizeOf((long[])this.currentHashes));
    }

    @Override
    public int getGroupCount() {
        return this.flatHash.size();
    }

    @Override
    public void appendValuesTo(int groupId, TsBlockBuilder pageBuilder) {
        ColumnBuilder[] columnBuilders = this.currentColumnBuilders;
        for (int i = 0; i < columnBuilders.length; ++i) {
            columnBuilders[i] = pageBuilder.getValueColumnBuilders()[i];
        }
        this.flatHash.appendTo(groupId, columnBuilders);
    }

    @Override
    public void addPage(Column[] page) {
        if (page[0].getPositionCount() == 0) {
            return;
        }
        this.currentPageSizeInBytes = Arrays.stream(page).mapToLong(Column::getRetainedSizeInBytes).sum();
        Column[] columns = this.getColumnsFromPage(page);
        this.addNonDictionaryPageWork(columns);
    }

    @Override
    public int[] getGroupIds(Column[] page) {
        if (page[0].getPositionCount() == 0) {
            return new int[0];
        }
        this.currentPageSizeInBytes = Arrays.stream(page).mapToLong(Column::getRetainedSizeInBytes).sum();
        Column[] columns = this.getColumnsFromPage(page);
        return this.getNonDictionaryPageWork(columns);
    }

    @Override
    public int getCapacity() {
        return this.flatHash.getCapacity();
    }

    private int putIfAbsent(Column[] columns, int position) {
        return this.flatHash.putIfAbsent(columns, position);
    }

    private long[] getHashesBufferArray() {
        if (this.currentHashes == null) {
            this.currentHashes = new long[1024];
        }
        return this.currentHashes;
    }

    private Column[] getColumnsFromPage(Column[] page) {
        Column[] blocks = this.currentColumns;
        Preconditions.checkArgument((page.length == blocks.length ? 1 : 0) != 0);
        System.arraycopy(page, 0, blocks, 0, blocks.length);
        return blocks;
    }

    public void addNonDictionaryPageWork(Column[] columns) {
        int batchSize;
        int lastPosition = 0;
        int positionCount = columns[0].getPositionCount();
        Preconditions.checkState((lastPosition <= positionCount ? 1 : 0) != 0, (Object)"position count out of bound");
        long[] hashes = this.getHashesBufferArray();
        for (int remainingPositions = positionCount - lastPosition; remainingPositions != 0; remainingPositions -= batchSize) {
            batchSize = Math.min(remainingPositions, hashes.length);
            if (!this.flatHash.ensureAvailableCapacity(batchSize)) {
                throw new RuntimeException("Memory for flatHash is not enough");
            }
            this.flatHash.computeHashes(columns, hashes, lastPosition, batchSize);
            for (int i = 0; i < batchSize; ++i) {
                this.flatHash.putIfAbsent(columns, lastPosition + i, hashes[i]);
            }
            lastPosition += batchSize;
        }
        Verify.verify((lastPosition == positionCount ? 1 : 0) != 0);
    }

    public int[] getNonDictionaryPageWork(Column[] columns) {
        int batchSize;
        int lastPosition = 0;
        int positionCount = columns[0].getPositionCount();
        int[] groupIds = new int[positionCount];
        Preconditions.checkState((lastPosition <= positionCount ? 1 : 0) != 0, (Object)"position count out of bound");
        long[] hashes = this.getHashesBufferArray();
        for (int remainingPositions = positionCount - lastPosition; remainingPositions != 0; remainingPositions -= batchSize) {
            batchSize = Math.min(remainingPositions, hashes.length);
            if (!this.flatHash.ensureAvailableCapacity(batchSize)) {
                throw new RuntimeException("Memory for flatHash is not enough");
            }
            this.flatHash.computeHashes(columns, hashes, lastPosition, batchSize);
            int i = 0;
            int position = lastPosition;
            while (i < batchSize) {
                groupIds[position] = this.flatHash.putIfAbsent(columns, lastPosition + i, hashes[i]);
                ++i;
                ++position;
            }
            lastPosition += batchSize;
        }
        Verify.verify((lastPosition == positionCount ? 1 : 0) != 0);
        return groupIds;
    }
}

