/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.persistence.partition.maintainer;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.utils.ThriftCommonsSerDeUtils;
import org.apache.iotdb.confignode.persistence.partition.maintainer.RegionMaintainTask;
import org.apache.iotdb.confignode.persistence.partition.maintainer.RegionMaintainType;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocol;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class RegionCreateTask
extends RegionMaintainTask {
    private String storageGroup;
    private TRegionReplicaSet regionReplicaSet;

    public RegionCreateTask() {
        super(RegionMaintainType.CREATE);
    }

    public RegionCreateTask(TDataNodeLocation targetDataNode, String storageGroup, TRegionReplicaSet regionReplicaSet) {
        super(RegionMaintainType.CREATE);
        this.targetDataNode = targetDataNode;
        this.storageGroup = storageGroup;
        this.regionReplicaSet = regionReplicaSet;
    }

    public String getStorageGroup() {
        return this.storageGroup;
    }

    public TRegionReplicaSet getRegionReplicaSet() {
        return this.regionReplicaSet;
    }

    @Override
    public TConsensusGroupId getRegionId() {
        return this.regionReplicaSet.getRegionId();
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeInt(RegionMaintainType.CREATE.ordinal());
        ThriftCommonsSerDeUtils.serializeTDataNodeLocation((TDataNodeLocation)this.targetDataNode, (DataOutputStream)stream);
        ReadWriteIOUtils.write((String)this.storageGroup, (OutputStream)stream);
        ThriftCommonsSerDeUtils.serializeTRegionReplicaSet((TRegionReplicaSet)this.regionReplicaSet, (DataOutputStream)stream);
    }

    @Override
    protected void deserialize(ByteBuffer buffer) throws IOException {
        this.targetDataNode = ThriftCommonsSerDeUtils.deserializeTDataNodeLocation((ByteBuffer)buffer);
        this.storageGroup = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        this.regionReplicaSet = ThriftCommonsSerDeUtils.deserializeTRegionReplicaSet((ByteBuffer)buffer);
    }

    @Override
    public void serialize(OutputStream outputStream, TProtocol protocol) throws IOException, TException {
        ReadWriteIOUtils.write((int)RegionMaintainType.CREATE.ordinal(), (OutputStream)outputStream);
        this.targetDataNode.write(protocol);
        ReadWriteIOUtils.write((String)this.storageGroup, (OutputStream)outputStream);
        this.regionReplicaSet.write(protocol);
    }

    @Override
    protected void deserialize(InputStream inputStream, TProtocol protocol) throws TException, IOException {
        this.targetDataNode = new TDataNodeLocation();
        this.targetDataNode.read(protocol);
        this.storageGroup = ReadWriteIOUtils.readString((InputStream)inputStream);
        this.regionReplicaSet = new TRegionReplicaSet();
        this.regionReplicaSet.read(protocol);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RegionCreateTask)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RegionCreateTask that = (RegionCreateTask)o;
        return this.storageGroup.equals(that.storageGroup) && this.regionReplicaSet.equals(that.regionReplicaSet);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.storageGroup, this.regionReplicaSet);
    }
}

