/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.execution.config.metadata.relational;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.iotdb.commons.schema.column.ColumnHeader;
import org.apache.iotdb.commons.schema.column.ColumnHeaderConstant;
import org.apache.iotdb.commons.schema.table.TreeViewSchema;
import org.apache.iotdb.commons.schema.table.TsTable;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnSchema;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeader;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeaderFactory;
import org.apache.iotdb.db.queryengine.plan.execution.config.ConfigTaskResult;
import org.apache.iotdb.db.queryengine.plan.execution.config.executor.IConfigTaskExecutor;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.relational.AbstractTableTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.relational.ShowCreateViewTask;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.utils.Binary;

public class ShowCreateTableTask
extends AbstractTableTask {
    public ShowCreateTableTask(String database, String tableName) {
        super(database, tableName);
    }

    @Override
    public ListenableFuture<ConfigTaskResult> execute(IConfigTaskExecutor configTaskExecutor) throws InterruptedException {
        return configTaskExecutor.describeTable(this.database, this.tableName, false, false);
    }

    public static void buildTsBlock(TsTable table, SettableFuture<ConfigTaskResult> future) {
        if (TreeViewSchema.isTreeViewTable((TsTable)table)) {
            ShowCreateViewTask.buildTsBlock(table, future);
            return;
        }
        List outputDataTypes = ColumnHeaderConstant.showCreateTableColumnHeaders.stream().map(ColumnHeader::getColumnType).collect(Collectors.toList());
        TsBlockBuilder builder = new TsBlockBuilder(outputDataTypes);
        builder.getTimeColumnBuilder().writeLong(0L);
        builder.getColumnBuilder(0).writeBinary(new Binary(table.getTableName(), TSFileConfig.STRING_CHARSET));
        builder.getColumnBuilder(1).writeBinary(new Binary(ShowCreateTableTask.getShowCreateTableSQL(table), TSFileConfig.STRING_CHARSET));
        builder.declarePosition();
        DatasetHeader datasetHeader = DatasetHeaderFactory.getShowCreateTableColumnHeader();
        future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS, builder.build(), datasetHeader));
    }

    private static String getShowCreateTableSQL(TsTable table) {
        StringBuilder builder = new StringBuilder("CREATE TABLE ").append(ShowCreateTableTask.getIdentifier(table.getTableName())).append(" (");
        block6: for (TsTableColumnSchema schema : table.getColumnList()) {
            switch (schema.getColumnCategory()) {
                case TAG: {
                    builder.append(ShowCreateTableTask.getIdentifier(schema.getColumnName())).append(" ").append(schema.getDataType()).append(" ").append("TAG");
                    break;
                }
                case TIME: {
                    continue block6;
                }
                case FIELD: {
                    builder.append(ShowCreateTableTask.getIdentifier(schema.getColumnName())).append(" ").append(schema.getDataType()).append(" ").append("FIELD");
                    break;
                }
                case ATTRIBUTE: {
                    builder.append(ShowCreateTableTask.getIdentifier(schema.getColumnName())).append(" ").append(schema.getDataType()).append(" ").append("ATTRIBUTE");
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported column type: " + schema.getColumnCategory());
                }
            }
            if (Objects.nonNull(schema.getProps().get("__comment"))) {
                builder.append(" COMMENT ").append(ShowCreateTableTask.getString((String)schema.getProps().get("__comment")));
            }
            builder.append(",");
        }
        if (table.getColumnList().size() > 1) {
            builder.deleteCharAt(builder.length() - 1);
        }
        builder.append(")");
        if (table.getPropValue("__comment").isPresent()) {
            builder.append(" COMMENT ").append(ShowCreateTableTask.getString((String)table.getPropValue("__comment").get()));
        }
        builder.append(" WITH (ttl=").append(table.getPropValue("ttl").orElse("'INF'")).append(")");
        return builder.toString();
    }

    public static String getIdentifier(@Nonnull String identifier) {
        return "\"" + identifier.replace("\"", "\"\"") + "\"";
    }

    public static String getString(@Nonnull String string) {
        return "'" + string.replace("'", "''") + "'";
    }
}

