/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.internal.introspection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.jexl3.annotations.NoJexl;
import org.apache.commons.jexl3.internal.introspection.ClassTool;
import org.apache.commons.jexl3.internal.introspection.PermissionsParser;
import org.apache.commons.jexl3.introspection.JexlPermissions;

public class Permissions
implements JexlPermissions {
    static final NoJexlClass NOJEXL_CLASS = new NoJexlClass(Collections.emptySet(), Collections.emptySet()){

        @Override
        boolean deny(Field field) {
            return true;
        }

        @Override
        boolean deny(Method method) {
            return true;
        }

        @Override
        boolean deny(Constructor<?> method) {
            return true;
        }
    };
    static final NoJexlClass JEXL_CLASS = new NoJexlClass(Collections.emptySet(), Collections.emptySet()){

        @Override
        boolean deny(Field field) {
            return false;
        }

        @Override
        boolean deny(Method method) {
            return false;
        }

        @Override
        boolean deny(Constructor<?> method) {
            return false;
        }
    };
    static final NoJexlPackage NOJEXL_PACKAGE = new NoJexlPackage(Collections.emptyMap()){

        @Override
        NoJexlClass getNoJexl(Class<?> clazz) {
            return NOJEXL_CLASS;
        }
    };
    static final NoJexlPackage JEXL_PACKAGE = new NoJexlPackage(Collections.emptyMap()){

        @Override
        NoJexlClass getNoJexl(Class<?> clazz) {
            return JEXL_CLASS;
        }
    };
    private final Map<String, NoJexlPackage> packages;
    private final Set<String> allowed;
    static final Permissions UNRESTRICTED = new Permissions();

    static String classKey(Class<?> clazz) {
        return Permissions.classKey(clazz, null);
    }

    static String classKey(Class<?> clazz, StringBuilder strb) {
        StringBuilder keyb = strb;
        Class<?> outer = clazz.getEnclosingClass();
        if (outer != null) {
            if (keyb == null) {
                keyb = new StringBuilder();
            }
            Permissions.classKey(outer, keyb);
            keyb.append('$');
        }
        if (keyb != null) {
            keyb.append(clazz.getSimpleName());
            return keyb.toString();
        }
        return clazz.getSimpleName();
    }

    protected Permissions() {
        this(Collections.emptySet(), Collections.emptyMap());
    }

    protected Permissions(Set<String> perimeter, Map<String, NoJexlPackage> nojexl) {
        this.allowed = perimeter;
        this.packages = nojexl;
    }

    @Override
    public Permissions compose(String ... src) {
        return new PermissionsParser().parse(new LinkedHashSet<String>(this.allowed), new ConcurrentHashMap<String, NoJexlPackage>(this.packages), src);
    }

    Map<String, NoJexlPackage> getPackages() {
        return this.packages == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.packages);
    }

    Set<String> getWildcards() {
        return this.allowed == null ? Collections.emptySet() : Collections.unmodifiableSet(this.allowed);
    }

    private NoJexlPackage getNoJexlPackage(String packageName) {
        NoJexlPackage njp = this.packages.get(packageName);
        return njp != null ? njp : JEXL_PACKAGE;
    }

    private NoJexlClass getNoJexl(Class<?> clazz) {
        NoJexlClass njc;
        String pkgName = ClassTool.getPackageName(clazz);
        NoJexlPackage njp = this.getNoJexlPackage(pkgName);
        if (njp != null && (njc = njp.getNoJexl(clazz)) != null) {
            return njc;
        }
        return JEXL_CLASS;
    }

    private boolean wildcardAllow(Class<?> clazz) {
        return Permissions.wildcardAllow(this.allowed, ClassTool.getPackageName(clazz));
    }

    static boolean wildcardAllow(Set<String> allowed, String name) {
        boolean found;
        boolean bl = found = allowed == null || allowed.isEmpty() || allowed.contains(name);
        if (!found) {
            String wildcard = name;
            int i = name.length();
            while (!found && i > 0) {
                wildcard = wildcard.substring(0, i);
                found = allowed.contains(wildcard + ".*");
                i = wildcard.lastIndexOf(46);
            }
        }
        return found;
    }

    private boolean deny(Package pack) {
        NoJexl nojexl = pack.getAnnotation(NoJexl.class);
        if (nojexl != null) {
            return true;
        }
        return Objects.equals(NOJEXL_PACKAGE, this.packages.get(pack.getName()));
    }

    private boolean deny(Class<?> clazz) {
        if (clazz.isArray()) {
            return false;
        }
        NoJexl nojexl = clazz.getAnnotation(NoJexl.class);
        if (nojexl != null) {
            return true;
        }
        NoJexlPackage njp = this.packages.get(ClassTool.getPackageName(clazz));
        return njp != null && Objects.equals(NOJEXL_CLASS, njp.getNoJexl(clazz));
    }

    private boolean deny(Constructor<?> ctor) {
        NoJexl nojexl = ctor.getAnnotation(NoJexl.class);
        if (nojexl != null) {
            return true;
        }
        return this.getNoJexl(ctor.getDeclaringClass()).deny(ctor);
    }

    private boolean deny(Field field) {
        NoJexl nojexl = field.getAnnotation(NoJexl.class);
        if (nojexl != null) {
            return true;
        }
        return this.getNoJexl(field.getDeclaringClass()).deny(field);
    }

    private boolean deny(Method method) {
        NoJexl nojexl = method.getAnnotation(NoJexl.class);
        if (nojexl != null) {
            return true;
        }
        return this.getNoJexl(method.getDeclaringClass()).deny(method);
    }

    @Override
    public boolean allow(Package pack) {
        return this.validate(pack) && !this.deny(pack);
    }

    @Override
    public boolean allow(Class<?> clazz) {
        if (!this.validate(clazz)) {
            return false;
        }
        if (this.deny(clazz)) {
            return false;
        }
        boolean explicit = this.wildcardAllow(clazz);
        for (Class<?> walk = clazz.getSuperclass(); walk != null; walk = walk.getSuperclass()) {
            if (this.deny(walk)) {
                return false;
            }
            if (explicit) continue;
            explicit = this.wildcardAllow(walk);
        }
        return explicit;
    }

    @Override
    public boolean allow(Constructor<?> ctor) {
        if (!this.validate(ctor)) {
            return false;
        }
        if (this.deny(ctor)) {
            return false;
        }
        Class<?> clazz = ctor.getDeclaringClass();
        if (this.deny(clazz)) {
            return false;
        }
        return this.wildcardAllow(clazz);
    }

    @Override
    public boolean allow(Field field) {
        if (!this.validate(field)) {
            return false;
        }
        if (this.deny(field)) {
            return false;
        }
        Class<?> clazz = field.getDeclaringClass();
        if (this.deny(clazz)) {
            return false;
        }
        return this.wildcardAllow(clazz);
    }

    @Override
    public boolean allow(Method method) {
        if (!this.validate(method)) {
            return false;
        }
        if (this.denyMethod(method)) {
            return false;
        }
        Class<?> clazz = method.getDeclaringClass();
        boolean[] explicit = new boolean[]{this.wildcardAllow(clazz)};
        for (Class<?> inter : clazz.getInterfaces()) {
            if (this.allow(inter, method, explicit)) continue;
            return false;
        }
        for (clazz = clazz.getSuperclass(); clazz != null; clazz = clazz.getSuperclass()) {
            if (this.allow(clazz, method, explicit)) continue;
            return false;
        }
        return explicit[0];
    }

    private boolean denyMethod(Method method) {
        return this.deny(method) || this.deny(method.getDeclaringClass());
    }

    private boolean allow(Class<?> clazz, Method method, boolean[] explicit) {
        try {
            Method override = clazz.getDeclaredMethod(method.getName(), method.getParameterTypes());
            if (this.denyMethod(override)) {
                return false;
            }
            if (!explicit[0]) {
                explicit[0] = this.wildcardAllow(clazz);
            }
            return true;
        }
        catch (NoSuchMethodException ex) {
            return true;
        }
        catch (SecurityException ex) {
            return false;
        }
    }

    static class NoJexlClass {
        protected Set<String> methodNames;
        protected Set<String> fieldNames;

        NoJexlClass(Set<String> methods, Set<String> fields) {
            this.methodNames = methods;
            this.fieldNames = fields;
        }

        boolean isEmpty() {
            return this.methodNames.isEmpty() && this.fieldNames.isEmpty();
        }

        NoJexlClass() {
            this(new HashSet<String>(), new HashSet<String>());
        }

        boolean deny(Field field) {
            return this.fieldNames.contains(field.getName());
        }

        boolean deny(Method method) {
            return this.methodNames.contains(method.getName());
        }

        boolean deny(Constructor<?> method) {
            return this.methodNames.contains(method.getDeclaringClass().getSimpleName());
        }
    }

    static class NoJexlPackage {
        protected Map<String, NoJexlClass> nojexl;

        NoJexlPackage(Map<String, NoJexlClass> map) {
            this.nojexl = map;
        }

        NoJexlPackage() {
            this(new ConcurrentHashMap<String, NoJexlClass>());
        }

        boolean isEmpty() {
            return this.nojexl.isEmpty();
        }

        public boolean equals(Object o) {
            return o == this;
        }

        NoJexlClass getNoJexl(Class<?> clazz) {
            return this.nojexl.get(Permissions.classKey(clazz));
        }

        void addNoJexl(String key, NoJexlClass njc) {
            this.nojexl.put(key, njc);
        }
    }
}

