/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.util.function.Function;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.init.configuration.CassandraConfiguration;
import org.apache.james.backends.cassandra.init.configuration.CassandraConsistenciesConfiguration;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.mailbox.acl.ACLDiff;
import org.apache.james.mailbox.cassandra.ids.CassandraId;
import org.apache.james.mailbox.cassandra.json.MailboxACLJsonConverter;
import org.apache.james.mailbox.exception.UnsupportedRightException;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.util.FunctionalUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class CassandraACLDAOV1 {
    public static final int INITIAL_VALUE = 0;
    private static final Logger LOG = LoggerFactory.getLogger(CassandraACLDAOV1.class);
    private static final String OLD_VERSION = "oldVersion";
    private final CassandraAsyncExecutor executor;
    private final int maxAclRetry;
    private final PreparedStatement conditionalInsertStatement;
    private final PreparedStatement conditionalUpdateStatement;
    private final PreparedStatement readStatement;
    private final PreparedStatement deleteStatement;
    private final ConsistencyLevel consistencyLevel;

    @Inject
    public CassandraACLDAOV1(Session session, CassandraConfiguration cassandraConfiguration, CassandraConsistenciesConfiguration consistenciesConfiguration) {
        this.executor = new CassandraAsyncExecutor(session);
        this.maxAclRetry = cassandraConfiguration.getAclMaxRetry();
        this.consistencyLevel = consistenciesConfiguration.getLightweightTransaction();
        this.conditionalInsertStatement = this.prepareConditionalInsert(session);
        this.conditionalUpdateStatement = this.prepareConditionalUpdate(session);
        this.readStatement = this.prepareReadStatement(session);
        this.deleteStatement = this.prepareDelete(session);
    }

    private PreparedStatement prepareDelete(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.delete().from("acl").where(QueryBuilder.eq((String)"id", (Object)QueryBuilder.bindMarker((String)"id"))).ifExists());
    }

    private PreparedStatement prepareConditionalInsert(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.insertInto((String)"acl").value("id", (Object)QueryBuilder.bindMarker((String)"id")).value("acl", (Object)QueryBuilder.bindMarker((String)"acl")).value("version", (Object)0).ifNotExists());
    }

    private PreparedStatement prepareConditionalUpdate(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.update((String)"acl").where(QueryBuilder.eq((String)"id", (Object)QueryBuilder.bindMarker((String)"id"))).with(QueryBuilder.set((String)"acl", (Object)QueryBuilder.bindMarker((String)"acl"))).and(QueryBuilder.set((String)"version", (Object)QueryBuilder.bindMarker((String)"version"))).onlyIf(QueryBuilder.eq((String)"version", (Object)QueryBuilder.bindMarker((String)OLD_VERSION))));
    }

    private PreparedStatement prepareReadStatement(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select((String[])new String[]{"acl", "version"}).from("acl").where(QueryBuilder.eq((String)"id", (Object)QueryBuilder.bindMarker((String)"id"))));
    }

    public Mono<MailboxACL> getACL(CassandraId cassandraId) {
        return this.getStoredACLRow(cassandraId).map(row -> this.getAcl(cassandraId, (Row)row));
    }

    private MailboxACL getAcl(CassandraId cassandraId, Row row) {
        String serializedACL = row.getString("acl");
        return this.deserializeACL(cassandraId, serializedACL);
    }

    public Mono<ACLDiff> updateACL(CassandraId cassandraId, MailboxACL.ACLCommand command) {
        return Mono.fromCallable(() -> MailboxACL.EMPTY.apply(command)).flatMap(replacement -> this.doUpdateAcl(cassandraId, aclWithVersion -> aclWithVersion.apply(command), (MailboxACL)replacement));
    }

    public Mono<ACLDiff> setACL(CassandraId cassandraId, MailboxACL mailboxACL) {
        return this.doUpdateAcl(cassandraId, acl -> new ACLWithVersion(acl.version, mailboxACL), mailboxACL);
    }

    Mono<ACLDiff> doUpdateAcl(CassandraId cassandraId, Function<ACLWithVersion, ACLWithVersion> aclTransformation, MailboxACL replacement) {
        return this.getAclWithVersion(cassandraId).flatMap(aclWithVersion -> this.updateStoredACL(cassandraId, (ACLWithVersion)aclTransformation.apply((ACLWithVersion)aclWithVersion)).map(newACL -> ACLDiff.computeDiff((MailboxACL)aclWithVersion.mailboxACL, (MailboxACL)newACL))).switchIfEmpty(this.insertACL(cassandraId, replacement).map(newACL -> ACLDiff.computeDiff((MailboxACL)MailboxACL.EMPTY, (MailboxACL)newACL))).single().retry((long)this.maxAclRetry);
    }

    private Mono<Row> getStoredACLRow(CassandraId cassandraId) {
        return this.executor.executeSingleRow(this.readStatement.bind().setUUID("id", cassandraId.asUuid()).setConsistencyLevel(this.consistencyLevel));
    }

    private Mono<MailboxACL> updateStoredACL(CassandraId cassandraId, ACLWithVersion aclWithVersion) {
        return this.executor.executeReturnApplied((Statement)this.conditionalUpdateStatement.bind().setUUID("id", cassandraId.asUuid()).setString("acl", this.convertAclToJson(aclWithVersion.mailboxACL)).setLong("version", aclWithVersion.version + 1L).setLong(OLD_VERSION, aclWithVersion.version)).filter(FunctionalUtils.identityPredicate()).map(any -> aclWithVersion.mailboxACL);
    }

    public Mono<Void> delete(CassandraId cassandraId) {
        return this.executor.executeVoid((Statement)this.deleteStatement.bind().setUUID("id", cassandraId.asUuid()));
    }

    private Mono<MailboxACL> insertACL(CassandraId cassandraId, MailboxACL acl) {
        return this.executor.executeReturnApplied((Statement)this.conditionalInsertStatement.bind().setUUID("id", cassandraId.asUuid()).setString("acl", this.convertAclToJson(acl))).filter(FunctionalUtils.identityPredicate()).map(any -> acl);
    }

    private String convertAclToJson(MailboxACL acl) {
        try {
            return MailboxACLJsonConverter.toJson(acl);
        }
        catch (JsonProcessingException exception) {
            throw new RuntimeException(exception);
        }
    }

    private Mono<ACLWithVersion> getAclWithVersion(CassandraId cassandraId) {
        return this.getStoredACLRow(cassandraId).map(acl -> new ACLWithVersion(acl.getLong("version"), this.deserializeACL(cassandraId, acl.getString("acl"))));
    }

    private MailboxACL deserializeACL(CassandraId cassandraId, String serializedACL) {
        try {
            return MailboxACLJsonConverter.toACL(serializedACL);
        }
        catch (IOException exception) {
            LOG.error("Unable to read stored ACL. We will use empty ACL instead.Mailbox is {} .ACL is {}", new Object[]{cassandraId, serializedACL, exception});
            return MailboxACL.EMPTY;
        }
    }

    private static class ACLWithVersion {
        private final long version;
        private final MailboxACL mailboxACL;

        public ACLWithVersion(long version, MailboxACL mailboxACL) {
            this.version = version;
            this.mailboxACL = mailboxACL;
        }

        public ACLWithVersion apply(MailboxACL.ACLCommand command) {
            try {
                return new ACLWithVersion(this.version, this.mailboxACL.apply(command));
            }
            catch (UnsupportedRightException exception) {
                throw new RuntimeException(exception);
            }
        }
    }
}

