/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core.fastfail;

import org.apache.james.core.MailAddress;
import org.apache.james.core.MaybeSender;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.dsn.DSNStatus;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.HookReturnCode;
import org.apache.james.protocols.smtp.hook.RcptHook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SupressDuplicateRcptHandler
implements RcptHook {
    private static final Logger LOGGER = LoggerFactory.getLogger(SupressDuplicateRcptHandler.class);

    @Override
    public HookResult doRcpt(SMTPSession session, MaybeSender sender, MailAddress rcpt) {
        return session.getAttachment(SMTPSession.RCPT_LIST, ProtocolSession.State.Transaction).filter(rcptList -> rcptList.contains(rcpt)).map(rcptList -> {
            StringBuilder responseBuffer = new StringBuilder();
            responseBuffer.append(DSNStatus.getStatus(2, "1.5")).append(" Recipient <").append(rcpt.toString()).append("> OK");
            LOGGER.debug("Duplicate recipient not add to recipient list: {}", (Object)rcpt);
            return HookResult.builder().hookReturnCode(HookReturnCode.ok()).smtpReturnCode("250").smtpDescription(responseBuffer.toString()).build();
        }).orElse(HookResult.DECLINED);
    }
}

