/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.alias.get;

import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.MasterNodeReadOperationRequestBuilder;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.util.ArrayUtils;

public abstract class BaseAliasesRequestBuilder<Response extends ActionResponse, Builder extends BaseAliasesRequestBuilder<Response, Builder>>
extends MasterNodeReadOperationRequestBuilder<GetAliasesRequest, Response, Builder> {
    public BaseAliasesRequestBuilder(ElasticsearchClient client, ActionType<Response> action, String ... aliases) {
        super(client, action, new GetAliasesRequest(aliases));
    }

    public Builder setAliases(String ... aliases) {
        ((GetAliasesRequest)this.request).aliases(aliases);
        return (Builder)this;
    }

    public Builder addAliases(String ... aliases) {
        ((GetAliasesRequest)this.request).aliases(ArrayUtils.concat(((GetAliasesRequest)this.request).aliases(), aliases));
        return (Builder)this;
    }

    public Builder setIndices(String ... indices) {
        ((GetAliasesRequest)this.request).indices(indices);
        return (Builder)this;
    }

    public Builder addIndices(String ... indices) {
        ((GetAliasesRequest)this.request).indices(ArrayUtils.concat(((GetAliasesRequest)this.request).indices(), indices));
        return (Builder)this;
    }

    public Builder setIndicesOptions(IndicesOptions options) {
        ((GetAliasesRequest)this.request).indicesOptions(options);
        return (Builder)this;
    }
}

