/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store;

import com.github.fge.lambdas.Throwing;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MessageRange;

public class MessageBatcher {
    public static final int NO_BATCH_SIZE = 0;
    private final int batchSize;

    public MessageBatcher(int batchSize) {
        Preconditions.checkArgument((batchSize >= 0 ? 1 : 0) != 0);
        this.batchSize = batchSize;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public List<MessageRange> batchMessages(MessageRange set, BatchedOperation batchedOperation) throws MailboxException {
        if (this.batchSize > 0) {
            return (List)set.split(this.batchSize).stream().flatMap(Throwing.function(range -> batchedOperation.execute((MessageRange)range).stream())).collect(ImmutableList.toImmutableList());
        }
        return batchedOperation.execute(set);
    }

    public static interface BatchedOperation {
        public List<MessageRange> execute(MessageRange var1) throws MailboxException;
    }
}

