/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.model.mailbox;

import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Optional;
import org.apache.james.mailbox.Role;

public class SortOrder
implements Comparable<SortOrder> {
    private static final SortOrder DEFAULT_SORT_ORDER = SortOrder.of(1000);
    private static final ImmutableMap<Role, SortOrder> defaultSortOrders = ImmutableMap.builder().put((Object)Role.INBOX, (Object)SortOrder.of(10)).put((Object)Role.ARCHIVE, (Object)SortOrder.of(20)).put((Object)Role.DRAFTS, (Object)SortOrder.of(30)).put((Object)Role.OUTBOX, (Object)SortOrder.of(40)).put((Object)Role.SENT, (Object)SortOrder.of(50)).put((Object)Role.TRASH, (Object)SortOrder.of(60)).put((Object)Role.SPAM, (Object)SortOrder.of(70)).put((Object)Role.TEMPLATES, (Object)SortOrder.of(80)).put((Object)Role.RESTORED_MESSAGES, (Object)SortOrder.of(90)).build();
    private final int sortOrder;

    private static Optional<SortOrder> getDefaultSortOrder(Role role) {
        return Optional.ofNullable((SortOrder)defaultSortOrders.get((Object)role));
    }

    public static SortOrder getSortOrder(Optional<Role> role) {
        return role.map(SortOrder::getDefaultSortOrder).map(Optional::get).orElse(DEFAULT_SORT_ORDER);
    }

    public static SortOrder of(int sortOrder) {
        Preconditions.checkArgument((sortOrder >= 0 ? 1 : 0) != 0, (Object)"'sortOrder' must be positive");
        return new SortOrder(sortOrder);
    }

    private SortOrder(int sortOrder) {
        this.sortOrder = sortOrder;
    }

    @JsonValue
    public int getSortOrder() {
        return this.sortOrder;
    }

    @Override
    public int compareTo(SortOrder o) {
        return Integer.compare(this.sortOrder, o.sortOrder);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("order", this.sortOrder).toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof SortOrder) {
            return this.sortOrder == ((SortOrder)obj).sortOrder;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.sortOrder});
    }
}

