/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.core.Username;
import org.apache.james.mailbox.cassandra.ids.CassandraMessageId;
import org.apache.james.mailbox.cassandra.mail.ThreadTablePartitionKey;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.store.mail.model.MimeMessageId;
import reactor.core.publisher.Mono;

public class CassandraThreadLookupDAO {
    private final CassandraAsyncExecutor executor;
    private final PreparedStatement insert;
    private final PreparedStatement select;
    private final PreparedStatement delete;

    @Inject
    public CassandraThreadLookupDAO(Session session) {
        this.executor = new CassandraAsyncExecutor(session);
        this.insert = session.prepare((RegularStatement)QueryBuilder.insertInto((String)"threadLookupTable").value("messageId", (Object)QueryBuilder.bindMarker((String)"messageId")).value("username", (Object)QueryBuilder.bindMarker((String)"username")).value("mimeMessageIds", (Object)QueryBuilder.bindMarker((String)"mimeMessageIds")));
        this.select = session.prepare((RegularStatement)QueryBuilder.select((String[])new String[]{"username", "mimeMessageIds"}).from("threadLookupTable").where(QueryBuilder.eq((String)"messageId", (Object)QueryBuilder.bindMarker((String)"messageId"))));
        this.delete = session.prepare((RegularStatement)QueryBuilder.delete().from("threadLookupTable").where(QueryBuilder.eq((String)"messageId", (Object)QueryBuilder.bindMarker((String)"messageId"))));
    }

    public Mono<Void> insert(MessageId messageId, Username username, Set<MimeMessageId> mimeMessageIds) {
        Set mimeMessageIdsString = (Set)mimeMessageIds.stream().map(MimeMessageId::getValue).collect(ImmutableSet.toImmutableSet());
        return this.executor.executeVoid((Statement)this.insert.bind().setUUID("messageId", ((CassandraMessageId)messageId).get()).setString("username", username.asString()).setSet("mimeMessageIds", mimeMessageIdsString));
    }

    public Mono<ThreadTablePartitionKey> selectOneRow(MessageId messageId) {
        return this.executor.executeSingleRow((Statement)this.select.bind().setUUID("messageId", ((CassandraMessageId)messageId).get())).map(this::readRow);
    }

    public Mono<Void> deleteOneRow(MessageId messageId) {
        return this.executor.executeVoid((Statement)this.delete.bind().setUUID("messageId", ((CassandraMessageId)messageId).get()));
    }

    private ThreadTablePartitionKey readRow(Row row) {
        Set mimeMessageIds = (Set)row.getSet("mimeMessageIds", String.class).stream().map(MimeMessageId::new).collect(ImmutableSet.toImmutableSet());
        return new ThreadTablePartitionKey(Username.of((String)row.getString("username")), mimeMessageIds);
    }
}

