/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imapserver.netty;

import java.net.InetSocketAddress;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imapserver.netty.NettyConstants;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.timeout.IdleState;
import org.jboss.netty.handler.timeout.IdleStateAwareChannelHandler;
import org.jboss.netty.handler.timeout.IdleStateEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImapIdleStateHandler
extends IdleStateAwareChannelHandler
implements NettyConstants {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImapIdleStateHandler.class);

    public void channelIdle(ChannelHandlerContext ctx, IdleStateEvent e) throws Exception {
        if (e.getState().equals((Object)IdleState.ALL_IDLE)) {
            ImapSession session = (ImapSession)attributes.get(ctx.getChannel());
            InetSocketAddress address = (InetSocketAddress)ctx.getChannel().getRemoteAddress();
            LOGGER.info("Logout client {} ({}) because it idled for too long...", (Object)address.getHostName(), (Object)address.getAddress().getHostAddress());
            session.logout();
            ctx.getChannel().close();
        }
        super.channelIdle(ctx, e);
    }
}

