/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.service;

import java.time.Clock;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.james.queue.api.MailQueueName;
import org.apache.james.queue.rabbitmq.RabbitMQMailQueue;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskType;

public class RepublishNotprocessedMailsTask
implements Task {
    public static final TaskType TYPE = TaskType.of((String)"republish-not-processed-mails");
    private final Instant olderThan;
    private final RabbitMQMailQueue mailQueue;
    private final AtomicInteger nbRequeuedMails;

    public RepublishNotprocessedMailsTask(RabbitMQMailQueue mailQueue, Instant olderThan) {
        this.olderThan = olderThan;
        this.mailQueue = mailQueue;
        this.nbRequeuedMails = new AtomicInteger(0);
    }

    public Task.Result run() {
        this.mailQueue.republishNotProcessedMails(this.olderThan).doOnNext(mailName -> this.nbRequeuedMails.getAndIncrement()).then().block();
        return Task.Result.COMPLETED;
    }

    public TaskType type() {
        return TYPE;
    }

    public Optional<TaskExecutionDetails.AdditionalInformation> details() {
        return Optional.of(new AdditionalInformation(this.mailQueue.getName(), this.olderThan, this.nbRequeuedMails.get(), Clock.systemUTC().instant()));
    }

    public Instant getOlderThan() {
        return this.olderThan;
    }

    public MailQueueName getMailQueue() {
        return this.mailQueue.getName();
    }

    public static class AdditionalInformation
    implements TaskExecutionDetails.AdditionalInformation {
        private final Instant timestamp;
        private final long nbRequeuedMails;
        private final MailQueueName mailQueue;
        private final Instant olderThan;

        public AdditionalInformation(MailQueueName mailQueue, Instant olderThan, long nbRequeuedMails, Instant timestamp) {
            this.mailQueue = mailQueue;
            this.olderThan = olderThan;
            this.timestamp = timestamp;
            this.nbRequeuedMails = nbRequeuedMails;
        }

        public Instant timestamp() {
            return this.timestamp;
        }

        public Instant getOlderThan() {
            return this.olderThan;
        }

        public MailQueueName getMailQueue() {
            return this.mailQueue;
        }

        public long getNbRequeuedMails() {
            return this.nbRequeuedMails;
        }
    }
}

