/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.extractor;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.james.mailbox.extractor.ParsedContent;
import org.apache.james.mailbox.extractor.TextExtractor;
import org.apache.james.mailbox.model.ContentType;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

public class JsoupTextExtractor
implements TextExtractor {
    private static final String TITLE_HTML_TAG = "title";
    private static final String NO_BASE_URI = "";
    private static final Map<String, List<String>> EMPTY_METADATA = ImmutableMap.of();
    private static final ContentType.MimeType TEXT_HTML = ContentType.MimeType.of((String)"text/html");
    private static final ContentType.MimeType TEXT_PLAIN = ContentType.MimeType.of((String)"text/plain");

    public ParsedContent extractContent(InputStream inputStream, ContentType contentType) throws Exception {
        if (inputStream == null || contentType == null) {
            return ParsedContent.empty();
        }
        Charset charset = contentType.charset().orElse(StandardCharsets.UTF_8);
        if (contentType.mimeType().equals((Object)TEXT_HTML)) {
            return this.parseHtmlContent(inputStream, charset);
        }
        if (contentType.mimeType().equals((Object)TEXT_PLAIN)) {
            return this.parsePlainTextContent(inputStream, charset);
        }
        return ParsedContent.empty();
    }

    private ParsedContent parsePlainTextContent(InputStream inputStream, Charset charset) throws IOException {
        return new ParsedContent(Optional.ofNullable(IOUtils.toString((InputStream)inputStream, (Charset)charset)), EMPTY_METADATA);
    }

    private ParsedContent parseHtmlContent(InputStream inputStream, Charset charset) throws IOException {
        Document doc = Jsoup.parse((InputStream)inputStream, (String)charset.name(), (String)NO_BASE_URI);
        doc.select(TITLE_HTML_TAG).remove();
        return new ParsedContent(Optional.ofNullable(doc.text()), EMPTY_METADATA);
    }
}

