/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jsieve;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jsieve.CommandManager;
import org.apache.jsieve.CommandManagerImpl;
import org.apache.jsieve.ComparatorManager;
import org.apache.jsieve.ComparatorManagerImpl;
import org.apache.jsieve.SieveConfigurationException;
import org.apache.jsieve.SieveFactory;
import org.apache.jsieve.TestManager;
import org.apache.jsieve.TestManagerImpl;
import org.xml.sax.SAXException;

public class ConfigurationManager {
    private static final int DEFAULT_INITIAL_CONCURRENCY_LEVEL = 8;
    private static final String COMMANDSMAP_PROPERTIES = "org/apache/jsieve/commandsmap.properties";
    private static final String TESTSMAP_PROPERTIES = "org/apache/jsieve/testsmap.properties";
    private static final String COMPARATORSMAP_PROPERTIES = "org/apache/jsieve/comparatorsmap.properties";
    private ConcurrentMap<String, String> fieldCommandMap;
    private ConcurrentMap<String, String> fieldTestMap;
    private ConcurrentMap<String, String> fieldComparatorMap;
    private int initialConcurrencyLevel = 8;
    private static final Log LOG = LogFactory.getLog((String)"org.apache.jsieve");
    private Log log = LOG;

    public ConfigurationManager() throws SieveConfigurationException {
        try {
            this.parse();
        }
        catch (SAXException e) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"Exception processing Configuration: ", (Throwable)e);
            }
            throw new SieveConfigurationException(e);
        }
        catch (IOException e) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"Exception processing Configuration: ", (Throwable)e);
            }
            throw new SieveConfigurationException(e);
        }
    }

    public int getInitialConcurrencyLevel() {
        return this.initialConcurrencyLevel;
    }

    public void setInitialConcurrencyLevel(int initialConcurrencyLevel) {
        this.initialConcurrencyLevel = initialConcurrencyLevel;
    }

    private InputStream getConfigStream(String configName) throws IOException {
        InputStream stream = null;
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader != null) {
            stream = contextClassLoader.getResourceAsStream(configName);
        }
        if (null == stream) {
            stream = ConfigurationManager.class.getClassLoader().getResourceAsStream(configName);
        }
        if (null == stream) {
            throw new IOException("Resource \"" + configName + "\" not found");
        }
        return stream;
    }

    public ConcurrentMap<String, String> getCommandMap() {
        if (null == this.fieldCommandMap) {
            this.fieldCommandMap = new ConcurrentHashMap<String, String>();
        }
        return this.fieldCommandMap;
    }

    public ConcurrentMap<String, String> getTestMap() {
        if (null == this.fieldTestMap) {
            this.fieldTestMap = new ConcurrentHashMap<String, String>();
        }
        return this.fieldTestMap;
    }

    public ConcurrentMap<String, String> getComparatorMap() {
        if (null == this.fieldComparatorMap) {
            this.fieldComparatorMap = new ConcurrentHashMap<String, String>();
        }
        return this.fieldComparatorMap;
    }

    private void parse() throws SAXException, IOException {
        this.setCommandMap(this.loadConfiguration(COMMANDSMAP_PROPERTIES));
        this.setTestMap(this.loadConfiguration(TESTSMAP_PROPERTIES));
        this.setComparatorMap(this.loadConfiguration(COMPARATORSMAP_PROPERTIES));
    }

    private ConcurrentMap<String, String> loadConfiguration(String name) throws IOException {
        Properties properties = this.loadProperties(name);
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>(properties.size(), 1.0f, this.initialConcurrencyLevel);
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            result.put(entry.getKey().toString(), entry.getValue().toString());
        }
        return result;
    }

    private Properties loadProperties(String name) throws IOException {
        InputStream is = this.getConfigStream(name);
        Properties p = new Properties();
        p.load(is);
        return p;
    }

    private void setCommandMap(ConcurrentMap<String, String> commandMap) {
        this.fieldCommandMap = commandMap;
    }

    private void setTestMap(ConcurrentMap<String, String> testMap) {
        this.fieldTestMap = testMap;
    }

    private void setComparatorMap(ConcurrentMap<String, String> comparatorMap) {
        this.fieldComparatorMap = comparatorMap;
    }

    public ComparatorManager getComparatorManager() {
        return new ComparatorManagerImpl(this.fieldComparatorMap);
    }

    public CommandManager getCommandManager() {
        return new CommandManagerImpl(this.fieldCommandMap);
    }

    public TestManager getTestManager() {
        return new TestManagerImpl(this.fieldTestMap);
    }

    public Log getLog() {
        return this.log;
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public SieveFactory build() {
        return new SieveFactory(this.getCommandManager(), this.getComparatorManager(), this.getTestManager(), this.getLog());
    }
}

