/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mdn.fields;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.james.mdn.action.mode.DispositionActionMode;
import org.apache.james.mdn.fields.Field;
import org.apache.james.mdn.modifier.DispositionModifier;
import org.apache.james.mdn.sending.mode.DispositionSendingMode;
import org.apache.james.mdn.type.DispositionType;

public class Disposition
implements Field {
    public static final String FIELD_NAME = "Disposition";
    private final DispositionActionMode actionMode;
    private final DispositionSendingMode sendingMode;
    private final DispositionType type;
    private final List<DispositionModifier> modifiers;

    public static Builder builder() {
        return new Builder();
    }

    @VisibleForTesting
    Disposition(DispositionActionMode actionMode, DispositionSendingMode sendingMode, DispositionType type, List<DispositionModifier> modifiers) {
        this.actionMode = actionMode;
        this.sendingMode = sendingMode;
        this.type = type;
        this.modifiers = ImmutableList.copyOf(modifiers);
    }

    public DispositionActionMode getActionMode() {
        return this.actionMode;
    }

    public DispositionSendingMode getSendingMode() {
        return this.sendingMode;
    }

    public DispositionType getType() {
        return this.type;
    }

    public List<DispositionModifier> getModifiers() {
        return this.modifiers;
    }

    @Override
    public String formattedValue() {
        return "Disposition: " + this.actionMode.getValue() + "/" + this.sendingMode.getValue() + ";" + this.type.getValue() + this.formattedModifiers();
    }

    private CharSequence formattedModifiers() {
        if (this.modifiers.isEmpty()) {
            return "";
        }
        return "/" + this.modifiers.stream().map(DispositionModifier::getValue).collect(Collectors.joining(","));
    }

    public final boolean equals(Object o) {
        if (o instanceof Disposition) {
            Disposition that = (Disposition)o;
            return Objects.equals((Object)this.actionMode, (Object)that.actionMode) && Objects.equals((Object)this.sendingMode, (Object)that.sendingMode) && Objects.equals((Object)this.type, (Object)that.type) && Objects.equals(this.modifiers, that.modifiers);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(new Object[]{this.actionMode, this.sendingMode, this.type, this.modifiers});
    }

    public String toString() {
        return this.formattedValue();
    }

    public static class Builder {
        private Optional<DispositionActionMode> actionMode = Optional.empty();
        private Optional<DispositionSendingMode> sendingMode = Optional.empty();
        private Optional<DispositionType> type = Optional.empty();
        private ImmutableList.Builder<DispositionModifier> modifiers = ImmutableList.builder();

        public Builder actionMode(DispositionActionMode actionMode) {
            this.actionMode = Optional.of(actionMode);
            return this;
        }

        public Builder sendingMode(DispositionSendingMode sendingMode) {
            this.sendingMode = Optional.of(sendingMode);
            return this;
        }

        public Builder type(DispositionType type) {
            this.type = Optional.of(type);
            return this;
        }

        public Builder addModifier(DispositionModifier modifier) {
            this.modifiers.add((Object)modifier);
            return this;
        }

        public Builder addModifiers(DispositionModifier ... modifiers) {
            this.modifiers.add(modifiers);
            return this;
        }

        public Disposition build() {
            Preconditions.checkState(this.actionMode.isPresent());
            Preconditions.checkState(this.sendingMode.isPresent());
            Preconditions.checkState(this.type.isPresent());
            return new Disposition(this.actionMode.get(), this.sendingMode.get(), this.type.get(), (List<DispositionModifier>)((Object)this.modifiers.build()));
        }
    }
}

