/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import org.apache.james.mime4j.Charsets;
import org.apache.james.mime4j.util.ByteArrayBuffer;
import org.apache.james.mime4j.util.ByteSequence;

public class ContentUtil {
    static final int DEFAULT_COPY_BUFFER_SIZE = 1024;

    private ContentUtil() {
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        int inputLength;
        byte[] buffer = new byte[1024];
        while (-1 != (inputLength = in.read(buffer))) {
            out.write(buffer, 0, inputLength);
        }
    }

    public static void copy(Reader in, Writer out) throws IOException {
        int inputLength;
        char[] buffer = new char[1024];
        while (-1 != (inputLength = in.read(buffer))) {
            out.write(buffer, 0, inputLength);
        }
    }

    public static byte[] buffer(InputStream in) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException("Input stream may not be null");
        }
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        ContentUtil.copy(in, buf);
        return buf.toByteArray();
    }

    public static String buffer(Reader in) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException("Reader may not be null");
        }
        StringWriter buf = new StringWriter();
        ContentUtil.copy(in, buf);
        return buf.toString();
    }

    public static ByteSequence encode(CharSequence string) {
        if (string == null) {
            return null;
        }
        ByteArrayBuffer buf = new ByteArrayBuffer(string.length());
        for (int i = 0; i < string.length(); ++i) {
            buf.append((byte)string.charAt(i));
        }
        return buf;
    }

    public static ByteSequence encode(Charset charset, CharSequence string) {
        if (string == null) {
            return null;
        }
        if (charset == null) {
            charset = Charset.defaultCharset();
        }
        ByteBuffer encoded = charset.encode(CharBuffer.wrap(string));
        ByteArrayBuffer buf = new ByteArrayBuffer(encoded.remaining());
        buf.append(encoded.array(), encoded.position(), encoded.remaining());
        return buf;
    }

    public static String decode(ByteSequence byteSequence) {
        if (byteSequence == null) {
            return null;
        }
        return ContentUtil.decode(byteSequence, 0, byteSequence.length());
    }

    public static String decode(Charset charset, ByteSequence byteSequence) {
        return ContentUtil.decode(charset, byteSequence, 0, byteSequence.length());
    }

    public static String decode(ByteSequence byteSequence, int offset, int length) {
        if (byteSequence == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder(length);
        for (int i = offset; i < offset + length; ++i) {
            buf.append((char)(byteSequence.byteAt(i) & 0xFF));
        }
        return buf.toString();
    }

    public static String decode(Charset charset, ByteSequence byteSequence, int offset, int length) {
        if (byteSequence == null) {
            return null;
        }
        if (charset == null) {
            charset = Charset.defaultCharset();
        }
        if (byteSequence instanceof ByteArrayBuffer) {
            ByteArrayBuffer bab = (ByteArrayBuffer)byteSequence;
            return ContentUtil.decode(charset, bab.buffer(), offset, length);
        }
        byte[] bytes = byteSequence.toByteArray();
        return ContentUtil.decode(charset, bytes, offset, length);
    }

    private static String decode(Charset charset, byte[] buffer, int offset, int length) {
        return charset.decode(ByteBuffer.wrap(buffer, offset, length)).toString();
    }

    public static byte[] toByteArray(String s2, Charset charset) {
        if (s2 == null) {
            return null;
        }
        try {
            return s2.getBytes((charset != null ? charset : Charsets.DEFAULT_CHARSET).name());
        }
        catch (UnsupportedEncodingException ex) {
            throw new Error(ex);
        }
    }

    public static byte[] toAsciiByteArray(String s2) {
        return ContentUtil.toByteArray(s2, Charsets.US_ASCII);
    }

    public static String toString(byte[] b, Charset charset) {
        if (b == null) {
            return null;
        }
        try {
            return new String(b, (charset != null ? charset : Charsets.DEFAULT_CHARSET).name());
        }
        catch (UnsupportedEncodingException ex) {
            throw new Error(ex);
        }
    }

    public static String toAsciiString(byte[] b) {
        return ContentUtil.toString(b, Charsets.US_ASCII);
    }

    public static String toString(byte[] b, int off, int len, Charset charset) {
        if (b == null) {
            return null;
        }
        try {
            return new String(b, off, len, (charset != null ? charset : Charsets.DEFAULT_CHARSET).name());
        }
        catch (UnsupportedEncodingException ex) {
            throw new Error(ex);
        }
    }

    public static String toAsciiString(byte[] b, int off, int len) {
        return ContentUtil.toString(b, off, len, Charsets.US_ASCII);
    }

    public static String toString(ByteArrayBuffer b, Charset charset) {
        if (b == null) {
            return null;
        }
        try {
            return new String(b.buffer(), 0, b.length(), (charset != null ? charset : Charsets.DEFAULT_CHARSET).name());
        }
        catch (UnsupportedEncodingException ex) {
            throw new Error(ex);
        }
    }

    public static String toAsciiString(ByteArrayBuffer b) {
        return ContentUtil.toString(b, Charsets.US_ASCII);
    }
}

