/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.matchers;

import org.parboiled.MatcherContext;
import org.parboiled.common.Preconditions;
import org.parboiled.common.StringUtils;
import org.parboiled.matchers.AbstractMatcher;
import org.parboiled.matchervisitors.MatcherVisitor;

public class CharIgnoreCaseMatcher
extends AbstractMatcher {
    public final char charLow;
    public final char charUp;

    public CharIgnoreCaseMatcher(char c) {
        super('\'' + StringUtils.escape(Character.toLowerCase(c)) + '/' + StringUtils.escape(Character.toUpperCase(c)) + '\'');
        this.charLow = Character.toLowerCase(c);
        this.charUp = Character.toUpperCase(c);
    }

    public boolean match(MatcherContext matcherContext) {
        char c = matcherContext.getCurrentChar();
        if (c != this.charLow && c != this.charUp) {
            return false;
        }
        matcherContext.advanceIndex(1);
        matcherContext.createNode();
        return true;
    }

    @Override
    public <R> R accept(MatcherVisitor<R> matcherVisitor) {
        Preconditions.checkArgNotNull(matcherVisitor, "visitor");
        return matcherVisitor.visit(this);
    }
}

