/*
 * Decompiled with CFR 0.152.
 */
package io.netty.incubator.codec.quic;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.incubator.codec.quic.FlushStrategy;
import io.netty.incubator.codec.quic.Quic;
import io.netty.incubator.codec.quic.QuicChannel;
import io.netty.incubator.codec.quic.QuicCodecBuilder;
import io.netty.incubator.codec.quic.QuicConnectionIdGenerator;
import io.netty.incubator.codec.quic.QuicSslEngine;
import io.netty.incubator.codec.quic.QuicTokenHandler;
import io.netty.incubator.codec.quic.QuicheConfig;
import io.netty.incubator.codec.quic.QuicheQuicServerCodec;
import io.netty.util.AttributeKey;
import io.netty.util.internal.ObjectUtil;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Function;

public final class QuicServerCodecBuilder
extends QuicCodecBuilder<QuicServerCodecBuilder> {
    private final Map<ChannelOption<?>, Object> options = new LinkedHashMap();
    private final Map<AttributeKey<?>, Object> attrs = new HashMap();
    private final Map<ChannelOption<?>, Object> streamOptions = new LinkedHashMap();
    private final Map<AttributeKey<?>, Object> streamAttrs = new HashMap();
    private ChannelHandler handler;
    private ChannelHandler streamHandler;
    private QuicConnectionIdGenerator connectionIdAddressGenerator;
    private QuicTokenHandler tokenHandler;

    public QuicServerCodecBuilder() {
        super(true);
    }

    private QuicServerCodecBuilder(QuicServerCodecBuilder builder) {
        super(builder);
        this.options.putAll(builder.options);
        this.attrs.putAll(builder.attrs);
        this.streamOptions.putAll(builder.streamOptions);
        this.streamAttrs.putAll(builder.streamAttrs);
        this.handler = builder.handler;
        this.streamHandler = builder.streamHandler;
        this.connectionIdAddressGenerator = builder.connectionIdAddressGenerator;
        this.tokenHandler = builder.tokenHandler;
    }

    @Override
    public QuicServerCodecBuilder clone() {
        return new QuicServerCodecBuilder(this);
    }

    public <T> QuicServerCodecBuilder option(ChannelOption<T> option, T value) {
        Quic.updateOptions(this.options, option, value);
        return (QuicServerCodecBuilder)this.self();
    }

    public <T> QuicServerCodecBuilder attr(AttributeKey<T> key, T value) {
        Quic.updateAttributes(this.attrs, key, value);
        return (QuicServerCodecBuilder)this.self();
    }

    public QuicServerCodecBuilder handler(ChannelHandler handler) {
        this.handler = (ChannelHandler)ObjectUtil.checkNotNull((Object)handler, (String)"handler");
        return (QuicServerCodecBuilder)this.self();
    }

    public <T> QuicServerCodecBuilder streamOption(ChannelOption<T> option, T value) {
        Quic.updateOptions(this.streamOptions, option, value);
        return (QuicServerCodecBuilder)this.self();
    }

    public <T> QuicServerCodecBuilder streamAttr(AttributeKey<T> key, T value) {
        Quic.updateAttributes(this.streamAttrs, key, value);
        return (QuicServerCodecBuilder)this.self();
    }

    public QuicServerCodecBuilder streamHandler(ChannelHandler streamHandler) {
        this.streamHandler = (ChannelHandler)ObjectUtil.checkNotNull((Object)streamHandler, (String)"streamHandler");
        return (QuicServerCodecBuilder)this.self();
    }

    public QuicServerCodecBuilder connectionIdAddressGenerator(QuicConnectionIdGenerator connectionIdAddressGenerator) {
        this.connectionIdAddressGenerator = connectionIdAddressGenerator;
        return this;
    }

    public QuicServerCodecBuilder tokenHandler(QuicTokenHandler tokenHandler) {
        this.tokenHandler = (QuicTokenHandler)ObjectUtil.checkNotNull((Object)tokenHandler, (String)"tokenHandler");
        return (QuicServerCodecBuilder)this.self();
    }

    @Override
    protected void validate() {
        super.validate();
        if (this.handler == null && this.streamHandler == null) {
            throw new IllegalStateException("handler and streamHandler not set");
        }
        if (this.tokenHandler == null) {
            throw new IllegalStateException("tokenHandler not set");
        }
    }

    @Override
    protected ChannelHandler build(QuicheConfig config, Function<QuicChannel, ? extends QuicSslEngine> sslEngineProvider, Executor sslTaskExecutor, int localConnIdLength, FlushStrategy flushStrategy) {
        this.validate();
        QuicTokenHandler tokenHandler = this.tokenHandler;
        QuicConnectionIdGenerator generator = this.connectionIdAddressGenerator;
        if (generator == null) {
            generator = QuicConnectionIdGenerator.signGenerator();
        }
        ChannelHandler handler = this.handler;
        ChannelHandler streamHandler = this.streamHandler;
        return new QuicheQuicServerCodec(config, localConnIdLength, tokenHandler, generator, flushStrategy, sslEngineProvider, sslTaskExecutor, handler, Quic.toOptionsArray(this.options), Quic.toAttributesArray(this.attrs), streamHandler, Quic.toOptionsArray(this.streamOptions), Quic.toAttributesArray(this.streamAttrs));
    }
}

