/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.StampedLock;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.james.mailbox.MailboxPathLocker;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.util.ReactorUtils;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public final class JVMMailboxPathLocker
implements MailboxPathLocker {
    private final ConcurrentHashMap<MailboxPath, StampedLock> paths = new ConcurrentHashMap();
    private static final int TTL_SECONDS = 60;
    private static final boolean DAEMON = true;
    public static final Scheduler LOCKER_WRAPPER = Schedulers.newBoundedElastic((int)Schedulers.DEFAULT_BOUNDED_ELASTIC_SIZE, (int)ReactorUtils.DEFAULT_BOUNDED_ELASTIC_QUEUESIZE, (String)"jvm-path-locker", (int)60, (boolean)true);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T executeWithLock(MailboxPath path, MailboxPathLocker.LockAwareExecution<T> execution, MailboxPathLocker.LockType writeLock) throws MailboxException {
        Lock lock = this.lock(path, writeLock);
        try {
            Object object = execution.execute();
            return (T)object;
        }
        finally {
            lock.unlock();
        }
    }

    public <T> Publisher<T> executeReactiveWithLockReactive(MailboxPath path, Publisher<T> execution, MailboxPathLocker.LockType lockType) {
        StampedLock stampedLock = this.getStampedLock(path);
        switch (lockType) {
            case Read: {
                return Flux.using(stampedLock::readLock, stamp -> Mono.from((Publisher)execution), stampedLock::unlockRead).subscribeOn(LOCKER_WRAPPER);
            }
            case Write: {
                return Flux.using(stampedLock::writeLock, stamp -> Mono.from((Publisher)execution), stampedLock::unlockWrite).subscribeOn(LOCKER_WRAPPER);
            }
        }
        throw new RuntimeException("Lock type not supported");
    }

    private Lock lock(MailboxPath path, MailboxPathLocker.LockType lockType) {
        StampedLock stampedLock = this.getStampedLock(path);
        Lock lock = this.getLock(stampedLock, lockType);
        lock.lock();
        return lock;
    }

    private StampedLock getStampedLock(MailboxPath path) {
        StampedLock storedLock;
        StampedLock stampedLock = this.paths.get(path);
        if (stampedLock == null && (storedLock = this.paths.putIfAbsent(path, stampedLock = new StampedLock())) != null) {
            stampedLock = storedLock;
        }
        return stampedLock;
    }

    private Lock getLock(StampedLock lock, MailboxPathLocker.LockType lockType) {
        switch (lockType) {
            case Write: {
                return lock.asWriteLock();
            }
            case Read: {
                return lock.asReadLock();
            }
        }
        throw new NotImplementedException("Unsupported lock tuype " + lockType);
    }
}

