/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.json;

import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import jakarta.json.stream.JsonParsingException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import org.opensearch.client.json.JsonEnum;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpDeserializerBase;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.JsonpUtils;
import org.opensearch.client.util.TaggedUnion;

public interface ExternallyTaggedUnion {
    public static <T extends JsonpSerializable & TaggedUnion<? extends JsonEnum, ?>> void serializeTypedKeys(Map<String, T> map, JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        ExternallyTaggedUnion.serializeTypedKeysInner(map, generator, mapper);
        generator.writeEnd();
    }

    public static <T extends JsonpSerializable & TaggedUnion<? extends JsonEnum, ?>> void serializeTypedKeysInner(Map<String, T> map, JsonGenerator generator, JsonpMapper mapper) {
        for (Map.Entry<String, T> entry : map.entrySet()) {
            JsonpSerializable value = (JsonpSerializable)entry.getValue();
            generator.writeKey(((JsonEnum)((TaggedUnion)((Object)value))._kind()).jsonValue() + "#" + entry.getKey());
            value.serialize(generator, mapper);
        }
    }

    public static class TypedKeysDeserializer<Union extends TaggedUnion<?, ?>>
    extends JsonpDeserializerBase<Map<String, Union>> {
        Deserializer<Union, ?> deserializer;

        protected TypedKeysDeserializer(Deserializer<Union, ?> deser) {
            super(EnumSet.of(JsonParser.Event.START_OBJECT));
            this.deserializer = deser;
        }

        @Override
        public Map<String, Union> deserialize(JsonParser parser, JsonpMapper mapper, JsonParser.Event event) {
            HashMap result = new HashMap();
            while ((event = parser.next()) != JsonParser.Event.END_OBJECT) {
                JsonpUtils.expectEvent(parser, event, JsonParser.Event.KEY_NAME);
                this.deserializeEntry(parser.getString(), parser, mapper, result);
            }
            return result;
        }

        public void deserializeEntry(String key, JsonParser parser, JsonpMapper mapper, Map<String, Union> targetMap) {
            int hashPos = key.indexOf(35);
            if (hashPos == -1) {
                throw new JsonParsingException("Property name '" + key + "' is not in the 'type#name' format. Make sure the request has 'typed_keys' set.", parser.getLocation());
            }
            String type = key.substring(0, hashPos);
            String name = key.substring(hashPos + 1);
            targetMap.put(name, this.deserializer.deserialize(type, parser, mapper));
        }
    }

    public static class Deserializer<Union extends TaggedUnion<?, Member>, Member> {
        private final Map<String, JsonpDeserializer<? extends Member>> deserializers;
        private final BiFunction<String, Member, Union> unionCtor;

        public Deserializer(Map<String, JsonpDeserializer<? extends Member>> deserializers, BiFunction<String, Member, Union> unionCtor) {
            this.deserializers = deserializers;
            this.unionCtor = unionCtor;
        }

        public Union deserialize(String type, JsonParser parser, JsonpMapper mapper) {
            JsonpDeserializer<Member> deserializer = this.deserializers.get(type);
            if (deserializer == null) {
                throw new JsonParsingException("Unknown variant type '" + type + "'", parser.getLocation());
            }
            return (Union)((TaggedUnion)this.unionCtor.apply(type, deserializer.deserialize(parser, mapper)));
        }

        public TypedKeysDeserializer<Union> typedKeys() {
            return new TypedKeysDeserializer(this);
        }
    }
}

