/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class InferenceClassImportance
implements JsonpSerializable {
    private final String className;
    private final double importance;
    public static final JsonpDeserializer<InferenceClassImportance> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, InferenceClassImportance::setupInferenceClassImportanceDeserializer);

    private InferenceClassImportance(Builder builder) {
        this.className = ApiTypeHelper.requireNonNull(builder.className, this, "className");
        this.importance = ApiTypeHelper.requireNonNull(builder.importance, this, "importance");
    }

    public static InferenceClassImportance of(Function<Builder, ObjectBuilder<InferenceClassImportance>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String className() {
        return this.className;
    }

    public final double importance() {
        return this.importance;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("class_name");
        generator.write(this.className);
        generator.writeKey("importance");
        generator.write(this.importance);
    }

    protected static void setupInferenceClassImportanceDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::className, JsonpDeserializer.stringDeserializer(), "class_name");
        op.add(Builder::importance, JsonpDeserializer.doubleDeserializer(), "importance");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<InferenceClassImportance> {
        private String className;
        private Double importance;

        public final Builder className(String value) {
            this.className = value;
            return this;
        }

        public final Builder importance(double value) {
            this.importance = value;
            return this;
        }

        @Override
        public InferenceClassImportance build() {
            this._checkSingleUse();
            return new InferenceClassImportance(this);
        }
    }
}

