/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.analysis;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.analysis.TokenFilterBase;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinition;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinitionVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class StopTokenFilter
extends TokenFilterBase
implements TokenFilterDefinitionVariant {
    @Nullable
    private final Boolean ignoreCase;
    @Nullable
    private final Boolean removeTrailing;
    private final List<String> stopwords;
    @Nullable
    private final String stopwordsPath;
    public static final JsonpDeserializer<StopTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, StopTokenFilter::setupStopTokenFilterDeserializer);

    private StopTokenFilter(Builder builder) {
        super(builder);
        this.ignoreCase = builder.ignoreCase;
        this.removeTrailing = builder.removeTrailing;
        this.stopwords = ApiTypeHelper.unmodifiableRequired(builder.stopwords, (Object)this, "stopwords");
        this.stopwordsPath = builder.stopwordsPath;
    }

    public static StopTokenFilter of(Function<Builder, ObjectBuilder<StopTokenFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenFilterDefinition.Kind _tokenFilterDefinitionKind() {
        return TokenFilterDefinition.Kind.Stop;
    }

    @Nullable
    public final Boolean ignoreCase() {
        return this.ignoreCase;
    }

    @Nullable
    public final Boolean removeTrailing() {
        return this.removeTrailing;
    }

    public final List<String> stopwords() {
        return this.stopwords;
    }

    @Nullable
    public final String stopwordsPath() {
        return this.stopwordsPath;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "stop");
        super.serializeInternal(generator, mapper);
        if (this.ignoreCase != null) {
            generator.writeKey("ignore_case");
            generator.write(this.ignoreCase.booleanValue());
        }
        if (this.removeTrailing != null) {
            generator.writeKey("remove_trailing");
            generator.write(this.removeTrailing.booleanValue());
        }
        if (ApiTypeHelper.isDefined(this.stopwords)) {
            generator.writeKey("stopwords");
            generator.writeStartArray();
            for (String item0 : this.stopwords) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.stopwordsPath != null) {
            generator.writeKey("stopwords_path");
            generator.write(this.stopwordsPath);
        }
    }

    protected static void setupStopTokenFilterDeserializer(ObjectDeserializer<Builder> op) {
        StopTokenFilter.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::ignoreCase, JsonpDeserializer.booleanDeserializer(), "ignore_case");
        op.add(Builder::removeTrailing, JsonpDeserializer.booleanDeserializer(), "remove_trailing");
        op.add(Builder::stopwords, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "stopwords");
        op.add(Builder::stopwordsPath, JsonpDeserializer.stringDeserializer(), "stopwords_path");
        op.ignore("type");
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<StopTokenFilter> {
        @Nullable
        private Boolean ignoreCase;
        @Nullable
        private Boolean removeTrailing;
        private List<String> stopwords;
        @Nullable
        private String stopwordsPath;

        public final Builder ignoreCase(@Nullable Boolean value) {
            this.ignoreCase = value;
            return this;
        }

        public final Builder removeTrailing(@Nullable Boolean value) {
            this.removeTrailing = value;
            return this;
        }

        public final Builder stopwords(List<String> list) {
            this.stopwords = Builder._listAddAll(this.stopwords, list);
            return this;
        }

        public final Builder stopwords(String value, String ... values) {
            this.stopwords = Builder._listAdd(this.stopwords, value, values);
            return this;
        }

        public final Builder stopwordsPath(@Nullable String value) {
            this.stopwordsPath = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public StopTokenFilter build() {
            this._checkSingleUse();
            return new StopTokenFilter(this);
        }
    }
}

