/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices.stats;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch.indices.stats.ShardLease;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class ShardRetentionLeases
implements JsonpSerializable {
    private final long primaryTerm;
    private final long version;
    private final List<ShardLease> leases;
    public static final JsonpDeserializer<ShardRetentionLeases> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShardRetentionLeases::setupShardRetentionLeasesDeserializer);

    private ShardRetentionLeases(Builder builder) {
        this.primaryTerm = ApiTypeHelper.requireNonNull(builder.primaryTerm, this, "primaryTerm");
        this.version = ApiTypeHelper.requireNonNull(builder.version, this, "version");
        this.leases = ApiTypeHelper.unmodifiableRequired(builder.leases, (Object)this, "leases");
    }

    public static ShardRetentionLeases of(Function<Builder, ObjectBuilder<ShardRetentionLeases>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long primaryTerm() {
        return this.primaryTerm;
    }

    public final long version() {
        return this.version;
    }

    public final List<ShardLease> leases() {
        return this.leases;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("primary_term");
        generator.write(this.primaryTerm);
        generator.writeKey("version");
        generator.write(this.version);
        if (ApiTypeHelper.isDefined(this.leases)) {
            generator.writeKey("leases");
            generator.writeStartArray();
            for (ShardLease item0 : this.leases) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupShardRetentionLeasesDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::primaryTerm, JsonpDeserializer.longDeserializer(), "primary_term");
        op.add(Builder::version, JsonpDeserializer.longDeserializer(), "version");
        op.add(Builder::leases, JsonpDeserializer.arrayDeserializer(ShardLease._DESERIALIZER), "leases");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<ShardRetentionLeases> {
        private Long primaryTerm;
        private Long version;
        private List<ShardLease> leases;

        public final Builder primaryTerm(long value) {
            this.primaryTerm = value;
            return this;
        }

        public final Builder version(long value) {
            this.version = value;
            return this;
        }

        public final Builder leases(List<ShardLease> list) {
            this.leases = Builder._listAddAll(this.leases, list);
            return this;
        }

        public final Builder leases(ShardLease value, ShardLease ... values) {
            this.leases = Builder._listAdd(this.leases, value, values);
            return this;
        }

        public final Builder leases(Function<ShardLease.Builder, ObjectBuilder<ShardLease>> fn) {
            return this.leases(fn.apply(new ShardLease.Builder()).build(), new ShardLease[0]);
        }

        @Override
        public ShardRetentionLeases build() {
            this._checkSingleUse();
            return new ShardRetentionLeases(this);
        }
    }
}

