/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import java.util.Set;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.AggregateUserEntityValidator;
import org.apache.james.DefaultUserEntityValidator;
import org.apache.james.RecipientRewriteTableUserEntityValidator;
import org.apache.james.UserEntityValidator;
import org.apache.james.domainlist.lib.DomainListConfiguration;
import org.apache.james.rrt.ForwardUsernameChangeTaskStep;
import org.apache.james.server.core.configuration.ConfigurationProvider;
import org.apache.james.user.api.UsernameChangeTaskStep;

public class CoreDataModule
extends AbstractModule {
    protected void configure() {
        Multibinder.newSetBinder((Binder)this.binder(), UserEntityValidator.class).addBinding().to(DefaultUserEntityValidator.class);
        Multibinder.newSetBinder((Binder)this.binder(), UserEntityValidator.class).addBinding().to(RecipientRewriteTableUserEntityValidator.class);
        Multibinder.newSetBinder((Binder)this.binder(), UsernameChangeTaskStep.class).addBinding().to(ForwardUsernameChangeTaskStep.class);
    }

    @Provides
    @Singleton
    UserEntityValidator userEntityValidator(Set<UserEntityValidator> validatorSet) {
        return new AggregateUserEntityValidator(validatorSet);
    }

    @Provides
    @Singleton
    public DomainListConfiguration provideDomainListConfiguration(ConfigurationProvider configurationProvider) throws ConfigurationException {
        return DomainListConfiguration.from((HierarchicalConfiguration)configurationProvider.getConfiguration("domainlist"));
    }
}

