/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.cassandra.upload;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.querybuilder.SchemaBuilder;
import com.datastax.oss.driver.api.querybuilder.schema.CreateTableWithOptions;
import com.datastax.oss.driver.api.querybuilder.schema.compaction.CompactionStrategy;
import com.datastax.oss.driver.api.querybuilder.schema.compaction.TimeWindowCompactionStrategy;
import org.apache.james.backends.cassandra.components.CassandraModule;

public interface UploadModule {
    public static final String TABLE_NAME = "uploads";
    public static final CqlIdentifier ID = CqlIdentifier.fromCql((String)"id");
    public static final CqlIdentifier CONTENT_TYPE = CqlIdentifier.fromCql((String)"content_type");
    public static final CqlIdentifier SIZE = CqlIdentifier.fromCql((String)"size");
    public static final CqlIdentifier BUCKET_ID = CqlIdentifier.fromCql((String)"bucket_id");
    public static final CqlIdentifier BLOB_ID = CqlIdentifier.fromCql((String)"blob_id");
    public static final CqlIdentifier USER = CqlIdentifier.fromCql((String)"user");
    public static final CassandraModule MODULE = CassandraModule.table((String)"uploads").comment("Holds JMAP uploads").options(options -> (CreateTableWithOptions)((CreateTableWithOptions)options.withCompaction((CompactionStrategy)SchemaBuilder.timeWindowCompactionStrategy().withCompactionWindow(7L, TimeWindowCompactionStrategy.CompactionWindowUnit.DAYS))).withCaching(true, SchemaBuilder.RowsPerPartition.rows((int)10))).statement(statement -> types -> statement.withPartitionKey(ID, DataTypes.TIMEUUID).withColumn(CONTENT_TYPE, DataTypes.TEXT).withColumn(SIZE, DataTypes.BIGINT).withColumn(BUCKET_ID, DataTypes.TEXT).withColumn(BLOB_ID, DataTypes.TEXT).withColumn(USER, DataTypes.TEXT)).build();
}

