/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.routes;

import com.google.common.base.CharMatcher;
import eu.timepit.refined.api.Refined;
import eu.timepit.refined.boolean;
import eu.timepit.refined.numeric;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValidationUtil;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.james.jmap.Endpoint;
import org.apache.james.jmap.JMAPRoute;
import org.apache.james.jmap.JMAPRoutes;
import org.apache.james.jmap.core.AccountId;
import org.apache.james.jmap.core.Id;
import org.apache.james.jmap.core.Id$;
import org.apache.james.jmap.core.ProblemDetails;
import org.apache.james.jmap.core.ProblemDetails$;
import org.apache.james.jmap.core.SessionTranslator;
import org.apache.james.jmap.exceptions.UnauthorizedException;
import org.apache.james.jmap.http.Authenticator;
import org.apache.james.jmap.json.ResponseSerializer$;
import org.apache.james.jmap.mail.BlobId;
import org.apache.james.jmap.mail.BlobId$;
import org.apache.james.jmap.method.AccountNotFoundException;
import org.apache.james.jmap.routes.Blob;
import org.apache.james.jmap.routes.BlobNotFoundException;
import org.apache.james.jmap.routes.BlobResolvers;
import org.apache.james.jmap.routes.DownloadRoutes$;
import org.apache.james.jmap.routes.ForbiddenException;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.model.ContentType;
import org.apache.james.mime4j.codec.EncoderUtil;
import org.apache.james.util.ReactorUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import play.api.libs.json.Json$;
import reactor.core.publisher.Mono;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import reactor.core.scheduler.Schedulers;
import reactor.netty.http.server.HttpServerRequest;
import reactor.netty.http.server.HttpServerResponse;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.compat.java8.FunctionConverters.package$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try;
import shapeless._0;

@ScalaSignature(bytes="\u0006\u0005\t%v!\u0002\u0014(\u0011\u0003\u0011d!\u0002\u001b(\u0011\u0003)\u0004\"\u0002\u001f\u0002\t\u0003i\u0004b\u0002 \u0002\u0005\u0004%\ta\u0010\u0005\u0007\r\u0006\u0001\u000b\u0011\u0002!\t\u000f\u001d\u000b!\u0019!C\u0001\u0011\"1A*\u0001Q\u0001\n%3A\u0001N\u0014\u0001\u001b\"A!l\u0002BC\u0002\u0013\u00051\f\u0003\u0005c\u000f\t\u0005\t\u0015!\u0003]\u0011!\u0019wA!b\u0001\n\u0003!\u0007\u0002\u00035\b\u0005\u0003\u0005\u000b\u0011B3\t\u0011%<!Q1A\u0005\u0002)D\u0001\"]\u0004\u0003\u0002\u0003\u0006Ia\u001b\u0005\u0006y\u001d!\tA\u001d\u0005\n\u0003\u001f9!\u0019!C\u0005\u0003#A\u0001\"!\u000b\bA\u0003%\u00111\u0003\u0005\n\u0003W9!\u0019!C\u0005\u0003#A\u0001\"!\f\bA\u0003%\u00111\u0003\u0005\n\u0003_9!\u0019!C\u0005\u0003#A\u0001\"!\r\bA\u0003%\u00111\u0003\u0005\n\u0003g9!\u0019!C\u0005\u0003#A\u0001\"!\u000e\bA\u0003%\u00111\u0003\u0005\n\u0003o9!\u0019!C\u0005\u0003sA\u0001\"a\u0010\bA\u0003%\u00111\b\u0005\u0007Q\u001d!\t%!\u0011\t\u000f\u0005es\u0001\"\u0003\u0002\\!9\u0011\u0011L\u0004\u0005\n\u0005U\u0005bBA_\u000f\u0011%\u0011q\u0018\u0005\b\u0003\u000f<A\u0011BAe\u0011\u001d\t\tp\u0002C\u0005\u0003gDq!!@\b\t\u0013\ty\u0010C\u0004\u0003\u0006\u001d!IAa\u0002\t\u000f\t\rs\u0001\"\u0003\u0003F!9!qJ\u0004\u0005\n\tE\u0003b\u0002B(\u000f\u0011%!1\f\u0005\b\u0005G:A\u0011\u0002B3\u0011%\u0011\tjBI\u0001\n\u0013\u0011\u0019*\u0001\bE_^tGn\\1e%>,H/Z:\u000b\u0005!J\u0013A\u0002:pkR,7O\u0003\u0002+W\u0005!!.\\1q\u0015\taS&A\u0003kC6,7O\u0003\u0002/_\u00051\u0011\r]1dQ\u0016T\u0011\u0001M\u0001\u0004_J<7\u0001\u0001\t\u0003g\u0005i\u0011a\n\u0002\u000f\t><h\u000e\\8bIJ{W\u000f^3t'\t\ta\u0007\u0005\u00028u5\t\u0001HC\u0001:\u0003\u0015\u00198-\u00197b\u0013\tY\u0004H\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003I\na\u0001T(H\u000f\u0016\u0013V#\u0001!\u0011\u0005\u0005#U\"\u0001\"\u000b\u0005\r{\u0013!B:mMRR\u0017BA#C\u0005\u0019aunZ4fe\u00069AjT$H\u000bJ\u0003\u0013a\u0003\"V\r\u001a+%kX*J5\u0016+\u0012!\u0013\t\u0003o)K!a\u0013\u001d\u0003\u0007%sG/\u0001\u0007C+\u001a3UIU0T\u0013j+\u0005eE\u0002\b\u001dZ\u0003\"a\u0014+\u000e\u0003AS!!\u0015*\u0002\t1\fgn\u001a\u0006\u0002'\u0006!!.\u0019<b\u0013\t)\u0006K\u0001\u0004PE*,7\r\u001e\t\u0003/bk\u0011!K\u0005\u00033&\u0012!BS'B!J{W\u000f^3t\u00035\tW\u000f\u001e5f]RL7-\u0019;peV\tA\f\u0005\u0002^A6\taL\u0003\u0002`S\u0005!\u0001\u000e\u001e;q\u0013\t\tgLA\u0007BkRDWM\u001c;jG\u0006$xN]\u0001\u000fCV$\b.\u001a8uS\u000e\fGo\u001c:!\u00035\u0011Gn\u001c2SKN|GN^3sgV\tQ\r\u0005\u00024M&\u0011qm\n\u0002\u000e\u00052|'MU3t_24XM]:\u0002\u001d\tdwN\u0019*fg>dg/\u001a:tA\u0005\t2/Z:tS>tGK]1og2\fGo\u001c:\u0016\u0003-\u0004\"\u0001\\8\u000e\u00035T!A\\\u0015\u0002\t\r|'/Z\u0005\u0003a6\u0014\u0011cU3tg&|g\u000e\u0016:b]Nd\u0017\r^8s\u0003I\u0019Xm]:j_:$&/\u00198tY\u0006$xN\u001d\u0011\u0015\rM$\u00181AA\u0003!\t\u0019t\u0001C\u0003[\u001d\u0001\u0007A\f\u000b\u0003umz|\bCA<}\u001b\u0005A(BA={\u0003\u0019IgN[3di*\t10A\u0003kCZ\f\u00070\u0003\u0002~q\n)a*Y7fI\u0006)a/\u00197vK\u0006\u0012\u0011\u0011A\u0001\t%\u001a\u001bU\u0006\u000f\u001c3c!)1M\u0004a\u0001K\")\u0011N\u0004a\u0001W\"\u001aa\"!\u0003\u0011\u0007]\fY!C\u0002\u0002\u000ea\u0014a!\u00138kK\u000e$\u0018AD1dG>,h\u000e^%e!\u0006\u0014\u0018-\\\u000b\u0003\u0003'\u0001B!!\u0006\u0002$9!\u0011qCA\u0010!\r\tI\u0002O\u0007\u0003\u00037Q1!!\b2\u0003\u0019a$o\\8u}%\u0019\u0011\u0011\u0005\u001d\u0002\rA\u0013X\rZ3g\u0013\u0011\t)#a\n\u0003\rM#(/\u001b8h\u0015\r\t\t\u0003O\u0001\u0010C\u000e\u001cw.\u001e8u\u0013\u0012\u0004\u0016M]1nA\u0005Y!\r\\8c\u0013\u0012\u0004\u0016M]1n\u00031\u0011Gn\u001c2JIB\u000b'/Y7!\u0003%q\u0017-\\3QCJ\fW.\u0001\u0006oC6,\u0007+\u0019:b[\u0002\n\u0001cY8oi\u0016tG\u000fV=qKB\u000b'/Y7\u0002#\r|g\u000e^3oiRK\b/\u001a)be\u0006l\u0007%A\u0006e_^tGn\\1e+JLWCAA\u001e!\ry\u0015QH\u0005\u0004\u0003K\u0001\u0016\u0001\u00043po:dw.\u00193Ve&\u0004CCAA\"!\u0019\t)%a\u0014\u0002T5\u0011\u0011q\t\u0006\u0005\u0003\u0013\nY%\u0001\u0004tiJ,\u0017-\u001c\u0006\u0004\u0003\u001b\u0012\u0016\u0001B;uS2LA!!\u0015\u0002H\t11\u000b\u001e:fC6\u00042aVA+\u0013\r\t9&\u000b\u0002\n\u00156\u000b\u0005KU8vi\u0016\f1aZ3u)\u0019\ti&!\u001e\u0002\fB1\u0011qLA6\u0003_j!!!\u0019\u000b\t\u0005\r\u0014QM\u0001\naV\u0014G.[:iKJT1A\\A4\u0015\t\tI'A\u0004sK\u0006\u001cGo\u001c:\n\t\u00055\u0014\u0011\r\u0002\u0005\u001b>tw\u000eE\u0002P\u0003cJ1!a\u001dQ\u0005\u00111v.\u001b3\t\u000f\u0005]$\u00041\u0001\u0002z\u00059!/Z9vKN$\b\u0003BA>\u0003\u000fk!!! \u000b\t\u0005}\u0014\u0011Q\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0007}\u000b\u0019I\u0003\u0003\u0002\u0006\u0006\u001d\u0014!\u00028fiRL\u0018\u0002BAE\u0003{\u0012\u0011\u0003\u0013;uaN+'O^3s%\u0016\fX/Z:u\u0011\u001d\tiI\u0007a\u0001\u0003\u001f\u000b\u0001B]3ta>t7/\u001a\t\u0005\u0003w\n\t*\u0003\u0003\u0002\u0014\u0006u$A\u0005%uiB\u001cVM\u001d<feJ+7\u000f]8og\u0016$\u0002\"a&\u0002*\u0006-\u0016Q\u0016\t\u0007\u00033\u000by*a)\u000e\u0005\u0005m%\u0002BA2\u0003;S1!OA3\u0013\u0011\t\t+a'\u0003\u000bMkuN\\8\u0011\u0007]\n)+C\u0002\u0002(b\u0012A!\u00168ji\"9\u0011qO\u000eA\u0002\u0005e\u0004bBAG7\u0001\u0007\u0011q\u0012\u0005\b\u0003_[\u0002\u0019AAY\u00039i\u0017-\u001b7c_b\u001cVm]:j_:\u0004B!a-\u0002:6\u0011\u0011Q\u0017\u0006\u0004\u0003o[\u0013aB7bS2\u0014w\u000e_\u0005\u0005\u0003w\u000b)L\u0001\bNC&d'm\u001c=TKN\u001c\u0018n\u001c8\u0002\u0015\u001d,G/\u00134Po:,'\u000f\u0006\u0005\u0002\u0018\u0006\u0005\u00171YAc\u0011\u001d\t9\b\ba\u0001\u0003sBq!!$\u001d\u0001\u0004\ty\tC\u0004\u00020r\u0001\r!!-\u0002\u0019\u0011|wO\u001c7pC\u0012\u0014En\u001c2\u0015\u0015\u0005]\u00151ZAk\u0003/\f9\u000fC\u0004\u0002Nv\u0001\r!a4\u0002\u0019=\u0004H/[8oC2t\u0015-\\3\u0011\u000b]\n\t.a\u0005\n\u0007\u0005M\u0007H\u0001\u0004PaRLwN\u001c\u0005\b\u0003\u001bk\u0002\u0019AAH\u0011\u001d\tI.\ba\u0001\u00037\fqB\u00197pE\u000e{g\u000e^3oiRK\b/\u001a\t\u0005\u0003;\f\u0019/\u0004\u0002\u0002`*!\u0011\u0011]A[\u0003\u0015iw\u000eZ3m\u0013\u0011\t)/a8\u0003\u0017\r{g\u000e^3oiRK\b/\u001a\u0005\b\u0003Sl\u0002\u0019AAv\u0003\u0011\u0011Gn\u001c2\u0011\u0007M\ni/C\u0002\u0002p\u001e\u0012AA\u00117pE\u0006Y\u0012\r\u001a3D_:$XM\u001c;ESN\u0004xn]5uS>t\u0007*Z1eKJ$B!!>\u0002|B9q'a>\u0002\u0010\u0006=\u0015bAA}q\tIa)\u001e8di&|g.\r\u0005\b\u0003\u001bt\u0002\u0019AAh\u0003M\u0019\u0018M\\5uSj,\u0007*Z1eKJ4\u0016\r\\;f)\u0011\t\u0019B!\u0001\t\u000f\t\rq\u00041\u0001\u0002\u0014\u0005\t1/\u0001\fbI\u0012\u001cuN\u001c;f]RdUM\\4uQ\"+\u0017\rZ3s)\u0011\t)P!\u0003\t\u000f\t-\u0001\u00051\u0001\u0003\u000e\u000591/\u001b>f)JL\bC\u0002B\b\u0005'\u00119\"\u0004\u0002\u0003\u0012)\u0019\u0011Q\n\u001d\n\t\tU!\u0011\u0003\u0002\u0004)JL\b\u0003\u0002B\r\u0005{qAAa\u0007\u000389!!Q\u0004B\u001a\u001d\u0011\u0011yBa\f\u000f\t\t\u0005\"Q\u0006\b\u0005\u0005G\u0011YC\u0004\u0003\u0003&\t%b\u0002BA\r\u0005OI\u0011\u0001M\u0005\u0003]=J!\u0001L\u0017\n\u0005)Z\u0013b\u0001B\u0019S\u0005\u0019\u0011\r]5\n\t\u0005\u0005(Q\u0007\u0006\u0004\u0005cI\u0013\u0002\u0002B\u001d\u0005w\tAaU5{K*!\u0011\u0011\u001dB\u001b\u0013\u0011\u0011yD!\u0011\u0003\tMK'0\u001a\u0006\u0005\u0005s\u0011Y$\u0001\u0017bI\u0012\u001cuN\u001c;f]R$\u0015n\u001d9pg&$\u0018n\u001c8IK\u0006$WM\u001d*fO\u0006\u0014H-\u001b8h\u000b:\u001cw\u000eZ5oOR1\u0011q\u0012B$\u0005\u0017BqA!\u0013\"\u0001\u0004\t\u0019\"\u0001\u0003oC6,\u0007b\u0002B'C\u0001\u0007\u0011qR\u0001\u0005e\u0016\u001c\b/\u0001\u0006rk\u0016\u0014\u0018\u0010U1sC6$b!a4\u0003T\t]\u0003b\u0002B+E\u0001\u0007\u0011\u0011P\u0001\fQR$\bOU3rk\u0016\u001cH\u000fC\u0004\u0003Z\t\u0002\r!a\u0005\u0002\u001bA\f'/Y7fi\u0016\u0014h*Y7f)\u0019\tyM!\u0018\u0003`!9!\u0011L\u0012A\u0002\u0005M\u0001b\u0002B1G\u0001\u0007\u00111C\u0001\u0004kJL\u0017A\u0004:fgB|g\u000e\u001a#fi\u0006LGn\u001d\u000b\t\u0003/\u00139Ga\u001b\u0003v!9!\u0011\u000e\u0013A\u0002\u0005=\u0015A\u00055uiB\u001cVM\u001d<feJ+7\u000f]8og\u0016DqA!\u001c%\u0001\u0004\u0011y'A\u0004eKR\f\u0017\u000e\\:\u0011\u00071\u0014\t(C\u0002\u0003t5\u0014a\u0002\u0015:pE2,W\u000eR3uC&d7\u000fC\u0005\u0003x\u0011\u0002\n\u00111\u0001\u0003z\u0005Q1\u000f^1ukN\u001cu\u000eZ3\u0011\t\tm$QR\u0007\u0003\u0005{R1a\u0018B@\u0015\u0011\u0011\tIa!\u0002\u000b\r|G-Z2\u000b\t\t\u0015%qQ\u0001\bQ\u0006tG\r\\3s\u0015\u0011\t)I!#\u000b\u0005\t-\u0015AA5p\u0013\u0011\u0011yI! \u0003%!#H\u000f\u001d*fgB|gn]3Ti\u0006$Xo]\u0001\u0019e\u0016\u001c\bo\u001c8e\t\u0016$\u0018-\u001b7tI\u0011,g-Y;mi\u0012\u001aTC\u0001BKU\u0011\u0011IHa&,\u0005\te\u0005\u0003\u0002BN\u0005Kk!A!(\u000b\t\t}%\u0011U\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa)9\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005O\u0013iJA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class DownloadRoutes
implements JMAPRoutes {
    private final Authenticator authenticator;
    private final BlobResolvers blobResolvers;
    private final SessionTranslator sessionTranslator;
    private final String accountIdParam;
    private final String blobIdParam;
    private final String nameParam;
    private final String contentTypeParam;
    private final String downloadUri;

    public static int BUFFER_SIZE() {
        return DownloadRoutes$.MODULE$.BUFFER_SIZE();
    }

    public static Logger LOGGER() {
        return DownloadRoutes$.MODULE$.LOGGER();
    }

    public Mono<Void> handleInternalError(HttpServerResponse x$1, Logger x$2, Throwable x$3) {
        return super.handleInternalError(x$1, x$2, x$3);
    }

    public Mono<Void> handleBadRequest(HttpServerResponse x$1, Logger x$2, Throwable x$3) {
        return super.handleBadRequest(x$1, x$2, x$3);
    }

    public Mono<Void> handleAuthenticationFailure(HttpServerResponse x$1, Logger x$2, Throwable x$3) {
        return super.handleAuthenticationFailure(x$1, x$2, x$3);
    }

    public Authenticator authenticator() {
        return this.authenticator;
    }

    public BlobResolvers blobResolvers() {
        return this.blobResolvers;
    }

    public SessionTranslator sessionTranslator() {
        return this.sessionTranslator;
    }

    private String accountIdParam() {
        return this.accountIdParam;
    }

    private String blobIdParam() {
        return this.blobIdParam;
    }

    private String nameParam() {
        return this.nameParam;
    }

    private String contentTypeParam() {
        return this.contentTypeParam;
    }

    private String downloadUri() {
        return this.downloadUri;
    }

    public Stream<JMAPRoute> routes() {
        return Stream.of((Object[])new JMAPRoute[]{JMAPRoute.builder().endpoint(new Endpoint(HttpMethod.GET, this.downloadUri())).action((request, response) -> this.get(request, response)).corsHeaders(), JMAPRoute.builder().endpoint(new Endpoint(HttpMethod.OPTIONS, this.downloadUri())).action(JMAPRoutes.CORS_CONTROL).noCorsHeaders()});
    }

    private Mono<Void> get(HttpServerRequest request, HttpServerResponse response) {
        return SMono$.MODULE$.apply((Publisher)this.authenticator().authenticate(request)).flatMap((Function1 & Serializable)mailboxSession -> this.getIfOwner(request, response, (MailboxSession)mailboxSession)).onErrorResume((Function1 & Serializable)x0$1 -> {
            Throwable throwable = x0$1;
            if (throwable instanceof ForbiddenException ? true : throwable instanceof AccountNotFoundException) {
                HttpResponseStatus x$1 = HttpResponseStatus.FORBIDDEN;
                String x$2 = "You cannot download in others accounts";
                String x$3 = ProblemDetails$.MODULE$.apply$default$1();
                Option<String> x$4 = ProblemDetails$.MODULE$.apply$default$3();
                return this.respondDetails(response, new ProblemDetails(x$3, x$1, x$4, "You cannot download in others accounts"), HttpResponseStatus.FORBIDDEN);
            }
            if (throwable instanceof UnauthorizedException) {
                UnauthorizedException unauthorizedException = (UnauthorizedException)throwable;
                DownloadRoutes$.MODULE$.LOGGER().warn("Unauthorized", (Throwable)unauthorizedException);
                HttpResponseStatus x$5 = HttpResponseStatus.UNAUTHORIZED;
                String x$6 = unauthorizedException.getMessage();
                String x$7 = ProblemDetails$.MODULE$.apply$default$1();
                Option<String> x$8 = ProblemDetails$.MODULE$.apply$default$3();
                return this.respondDetails(unauthorizedException.addHeaders(response), new ProblemDetails(x$7, x$5, x$8, x$6), HttpResponseStatus.UNAUTHORIZED);
            }
            if (throwable instanceof BlobNotFoundException) {
                HttpResponseStatus x$9 = HttpResponseStatus.NOT_FOUND;
                String x$10 = "The resource could not be found";
                String x$11 = ProblemDetails$.MODULE$.apply$default$1();
                Option<String> x$12 = ProblemDetails$.MODULE$.apply$default$3();
                return this.respondDetails(response, new ProblemDetails(x$11, x$9, x$12, "The resource could not be found"), HttpResponseStatus.NOT_FOUND);
            }
            DownloadRoutes$.MODULE$.LOGGER().error("Unexpected error upon downloads", throwable);
            HttpResponseStatus x$13 = HttpResponseStatus.INTERNAL_SERVER_ERROR;
            String x$14 = throwable.getMessage();
            String x$15 = ProblemDetails$.MODULE$.apply$default$1();
            Option<String> x$16 = ProblemDetails$.MODULE$.apply$default$3();
            return this.respondDetails(response, new ProblemDetails(x$15, x$13, x$16, x$14), HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }).subscribeOn(ReactorUtils.BLOCKING_CALL_WRAPPER).asJava().then();
    }

    private SMono<BoxedUnit> get(HttpServerRequest request, HttpServerResponse response, MailboxSession mailboxSession) {
        return ((SMono)BlobId$.MODULE$.of(request.param((CharSequence)this.blobIdParam())).fold((Function1 & Serializable)e -> SMono$.MODULE$.error(e), (Function1 & Serializable)x$4 -> this.blobResolvers().resolve((BlobId)x$4, mailboxSession))).flatMap((Function1 & Serializable)blob -> this.downloadBlob(this.queryParam(request, this.nameParam()), response, (ContentType)this.queryParam(request, this.contentTypeParam()).map((Function1 & Serializable)x$1 -> ContentType.of((String)x$1)).getOrElse((Function0 & Serializable)() -> blob.contentType()), (Blob)blob).then());
    }

    private SMono<BoxedUnit> getIfOwner(HttpServerRequest request, HttpServerResponse response, MailboxSession mailboxSession) {
        Left left;
        IllegalArgumentException throwable;
        Right right;
        String id;
        Either<IllegalArgumentException, Refined<String, Id.IdConstraint>> either = Id$.MODULE$.validate(request.param((CharSequence)this.accountIdParam()));
        if (either instanceof Right && new Refined((Object)(id = (String)((Refined)(right = (Right)either).value()).value())) instanceof Refined) {
            String string2 = id;
            return this.sessionTranslator().delegateIfNeeded(mailboxSession, new AccountId(string2)).flatMap((Function1 & Serializable)session -> this.get(request, response, (MailboxSession)session));
        }
        if (either instanceof Left && (throwable = (IllegalArgumentException)(left = (Left)either).value()) != null) {
            IllegalArgumentException illegalArgumentException = throwable;
            return SMono$.MODULE$.error((Throwable)illegalArgumentException);
        }
        throw new MatchError(either);
    }

    private SMono<BoxedUnit> downloadBlob(Option<String> optionalName, HttpServerResponse response, ContentType blobContentType, Blob blob) {
        return SMono$.MODULE$.fromPublisher((Publisher)Mono.using(() -> blob.content(), stream -> ((HttpServerResponse)this.addContentDispositionHeader(optionalName).compose(this.addContentLengthHeader(blob.size())).apply((Object)response)).header((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)this.sanitizeHeaderValue(blobContentType.asString())).status(HttpResponseStatus.OK).send((Publisher)ReactorUtils.toChunks((InputStream)stream, (int)DownloadRoutes$.MODULE$.BUFFER_SIZE()).map(x$5 -> Unpooled.wrappedBuffer((ByteBuffer)x$5)).subscribeOn(Schedulers.boundedElastic())).then(), (Consumer)package$.MODULE$.asJavaConsumer((Function1 & Serializable)stream -> {
            stream.close();
            return BoxedUnit.UNIT;
        }))).then();
    }

    private Function1<HttpServerResponse, HttpServerResponse> addContentDispositionHeader(Option<String> optionalName) {
        return (Function1 & Serializable)resp -> (HttpServerResponse)optionalName.map((Function1 & Serializable)x$6 -> this.addContentDispositionHeaderRegardingEncoding((String)x$6, (HttpServerResponse)resp)).getOrElse((Function0 & Serializable)() -> resp);
    }

    private String sanitizeHeaderValue(String s) {
        if (HttpHeaderValidationUtil.validateValidHeaderValue((CharSequence)s) == -1) {
            return s;
        }
        return "application/octet-stream";
    }

    private Function1<HttpServerResponse, HttpServerResponse> addContentLengthHeader(Try<Refined<Object, boolean.Not<numeric.Less<_0>>>> sizeTry) {
        return (Function1 & Serializable)resp -> (HttpServerResponse)sizeTry.map((Function1 & Serializable)size -> resp.header((CharSequence)"Content-Length", (CharSequence)((Long)((Refined)size).value()).toString())).getOrElse((Function0 & Serializable)() -> resp);
    }

    private HttpServerResponse addContentDispositionHeaderRegardingEncoding(String name, HttpServerResponse resp) {
        if (CharMatcher.ascii().matchesAllOf((CharSequence)name)) {
            return resp.header((CharSequence)"Content-Disposition", (CharSequence)new StringBuilder(23).append("attachment; filename=\"").append(name).append("\"").toString());
        }
        return resp.header((CharSequence)"Content-Disposition", (CharSequence)new StringBuilder(24).append("attachment; filename*=\"").append(EncoderUtil.encodeEncodedWord((String)name, (EncoderUtil.Usage)EncoderUtil.Usage.TEXT_TOKEN)).append("\"").toString());
    }

    private Option<String> queryParam(HttpServerRequest httpRequest, String parameterName) {
        return this.queryParam(parameterName, httpRequest.uri());
    }

    private Option<String> queryParam(String parameterName, String uri) {
        return Option$.MODULE$.apply(new QueryStringDecoder(uri).parameters().get(parameterName)).toList().flatMap((Function1 & Serializable)x$7 -> CollectionConverters$.MODULE$.ListHasAsScala(x$7).asScala()).headOption();
    }

    private SMono<BoxedUnit> respondDetails(HttpServerResponse httpServerResponse, ProblemDetails details, HttpResponseStatus statusCode) {
        return SMono$.MODULE$.fromCallable(() -> ResponseSerializer$.MODULE$.serialize(details)).map((Function1 & Serializable)json -> Json$.MODULE$.stringify(json)).map((Function1 & Serializable)x$8 -> x$8.getBytes(StandardCharsets.UTF_8)).flatMap((Function1 & Serializable)bytes -> SMono$.MODULE$.fromPublisher((Publisher)httpServerResponse.status(statusCode).header((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"application/json").header((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (CharSequence)Integer.toString(((byte[])bytes).length)).sendByteArray((Publisher)SMono$.MODULE$.just(bytes)).then()).then());
    }

    private HttpResponseStatus respondDetails$default$3() {
        return HttpResponseStatus.BAD_REQUEST;
    }

    @Inject
    public DownloadRoutes(@Named(value="RFC-8621") Authenticator authenticator, BlobResolvers blobResolvers, SessionTranslator sessionTranslator) {
        this.authenticator = authenticator;
        this.blobResolvers = blobResolvers;
        this.sessionTranslator = sessionTranslator;
        this.accountIdParam = "accountId";
        this.blobIdParam = "blobId";
        this.nameParam = "name";
        this.contentTypeParam = "type";
        this.downloadUri = new StringBuilder(15).append("/download/{").append(this.accountIdParam()).append("}/{").append(this.blobIdParam()).append("}").toString();
    }
}

