/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.mail.Flags;
import org.apache.james.blob.api.BlobId;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.ModSeq;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.ByteContent;
import org.apache.james.mailbox.model.ComposedMessageId;
import org.apache.james.mailbox.model.ComposedMessageIdWithMetaData;
import org.apache.james.mailbox.model.Content;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageAttachmentMetadata;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.ThreadId;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.mail.model.impl.Properties;
import org.apache.james.mailbox.store.mail.model.impl.PropertyBuilder;
import org.apache.james.mailbox.store.mail.model.impl.SimpleMailboxMessage;

public class CassandraMessageMetadata {
    private final ComposedMessageIdWithMetaData composedMessageId;
    private final Optional<Date> internalDate;
    private final Optional<Date> saveDate;
    private final Optional<Long> bodyStartOctet;
    private final Optional<Long> size;
    private final Optional<BlobId> headerContent;

    public static Builder builder() {
        return new Builder();
    }

    public static CassandraMessageMetadata from(MailboxMessage mailboxMessage, BlobId headerBlobId) {
        return new CassandraMessageMetadata(ComposedMessageIdWithMetaData.builder().composedMessageId(new ComposedMessageId(mailboxMessage.getMailboxId(), mailboxMessage.getMessageId(), mailboxMessage.getUid())).modSeq(mailboxMessage.getModSeq()).flags(mailboxMessage.createFlags()).threadId(mailboxMessage.getThreadId()).build(), Optional.of(mailboxMessage.getInternalDate()), mailboxMessage.getSaveDate(), Optional.of(mailboxMessage.getHeaderOctets()), Optional.of(mailboxMessage.getFullContentOctets()), Optional.of(headerBlobId));
    }

    public static CassandraMessageMetadata from(MailboxMessage mailboxMessage) {
        Preconditions.checkArgument((boolean)(mailboxMessage instanceof CassandraMailboxMessage), (Object)"Requires a CassandraMailboxMessage");
        CassandraMailboxMessage cassandraMailboxMessage = (CassandraMailboxMessage)mailboxMessage;
        return CassandraMessageMetadata.from(mailboxMessage, cassandraMailboxMessage.headerBlobId);
    }

    public CassandraMessageMetadata(ComposedMessageIdWithMetaData composedMessageId, Optional<Date> internalDate, Optional<Date> saveDate, Optional<Long> bodyStartOctet, Optional<Long> size, Optional<BlobId> headerContent) {
        this.composedMessageId = composedMessageId;
        this.internalDate = internalDate;
        this.saveDate = saveDate;
        this.bodyStartOctet = bodyStartOctet;
        this.size = size;
        this.headerContent = headerContent;
    }

    public boolean isComplete() {
        return this.internalDate.isPresent() && this.bodyStartOctet.isPresent() && this.size.isPresent() && this.headerContent.isPresent();
    }

    public MailboxMessage asMailboxMessage(byte[] headerContent) {
        Preconditions.checkState((boolean)this.isComplete());
        return new CassandraMailboxMessage((MailboxMessage)SimpleMailboxMessage.builder().mailboxId(this.composedMessageId.getComposedMessageId().getMailboxId()).messageId(this.composedMessageId.getComposedMessageId().getMessageId()).threadId(this.composedMessageId.getThreadId()).uid(this.composedMessageId.getComposedMessageId().getUid()).modseq(this.composedMessageId.getModSeq()).flags(this.composedMessageId.getFlags()).content((Content)new ByteContent(headerContent)).size(this.size.get().longValue()).bodyStartOctet(Math.toIntExact(this.bodyStartOctet.get())).internalDate(this.internalDate.get()).saveDate(this.saveDate).properties(new PropertyBuilder()).build(), this.getHeaderContent().get());
    }

    public Optional<BlobId> getHeaderContent() {
        return this.headerContent;
    }

    public ComposedMessageIdWithMetaData getComposedMessageId() {
        return this.composedMessageId;
    }

    public Optional<Date> getInternalDate() {
        return this.internalDate;
    }

    public Optional<Long> getBodyStartOctet() {
        return this.bodyStartOctet;
    }

    public Optional<Long> getSize() {
        return this.size;
    }

    public Optional<Date> getSaveDate() {
        return this.saveDate;
    }

    public CassandraMessageMetadata withMailboxId(MailboxId mailboxId) {
        return CassandraMessageMetadata.builder().internalDate(this.internalDate).saveDate(this.saveDate).size(this.size).bodyStartOctet(this.bodyStartOctet).headerContent(this.headerContent).ids(ComposedMessageIdWithMetaData.builder().flags(this.composedMessageId.getFlags()).modSeq(this.composedMessageId.getModSeq()).threadId(this.composedMessageId.getThreadId()).composedMessageId(new ComposedMessageId(mailboxId, this.composedMessageId.getComposedMessageId().getMessageId(), this.composedMessageId.getComposedMessageId().getUid())).build()).build();
    }

    public boolean equals(Object obj) {
        if (obj instanceof CassandraMessageMetadata) {
            CassandraMessageMetadata other = (CassandraMessageMetadata)obj;
            return Objects.equal((Object)this.composedMessageId, (Object)other.composedMessageId) && Objects.equal(this.internalDate, other.internalDate) && Objects.equal(this.saveDate, other.saveDate) && Objects.equal(this.bodyStartOctet, other.bodyStartOctet) && Objects.equal(this.size, other.size) && Objects.equal(this.headerContent, other.headerContent);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.composedMessageId, this.internalDate, this.saveDate, this.bodyStartOctet, this.size, this.headerContent});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("composedMessageId", (Object)this.composedMessageId).add("internalDate", this.internalDate).add("saveDate", this.saveDate).add("bodyStartOctet", this.bodyStartOctet).add("size", this.size).add("headerContent", this.headerContent).toString();
    }

    public static class CassandraMailboxMessage
    implements MailboxMessage {
        private final MailboxMessage delegate;
        private final BlobId headerBlobId;

        public CassandraMailboxMessage(MailboxMessage delegate, BlobId headerBlobId) {
            this.delegate = delegate;
            this.headerBlobId = headerBlobId;
        }

        public ComposedMessageIdWithMetaData getComposedMessageIdWithMetaData() {
            return this.delegate.getComposedMessageIdWithMetaData();
        }

        public MailboxId getMailboxId() {
            return this.delegate.getMailboxId();
        }

        public MessageUid getUid() {
            return this.delegate.getUid();
        }

        public void setUid(MessageUid uid) {
            this.delegate.setUid(uid);
        }

        public void setModSeq(ModSeq modSeq) {
            this.delegate.setModSeq(modSeq);
        }

        public ModSeq getModSeq() {
            return this.delegate.getModSeq();
        }

        public boolean isAnswered() {
            return this.delegate.isAnswered();
        }

        public boolean isDeleted() {
            return this.delegate.isDeleted();
        }

        public boolean isDraft() {
            return this.delegate.isDraft();
        }

        public boolean isFlagged() {
            return this.delegate.isFlagged();
        }

        public boolean isRecent() {
            return this.delegate.isRecent();
        }

        public boolean isSeen() {
            return this.delegate.isSeen();
        }

        public void setFlags(Flags flags) {
            this.delegate.setFlags(flags);
        }

        public void setSaveDate(Date saveDate) {
            this.delegate.setSaveDate(saveDate);
        }

        public Flags createFlags() {
            return this.delegate.createFlags();
        }

        public MessageId getMessageId() {
            return this.delegate.getMessageId();
        }

        public Date getInternalDate() {
            return this.delegate.getInternalDate();
        }

        public InputStream getBodyContent() throws IOException {
            return this.delegate.getBodyContent();
        }

        public String getMediaType() {
            return this.delegate.getMediaType();
        }

        public String getSubType() {
            return this.delegate.getSubType();
        }

        public long getBodyOctets() {
            return this.delegate.getBodyOctets();
        }

        public long getFullContentOctets() {
            return this.delegate.getFullContentOctets();
        }

        public long getHeaderOctets() {
            return this.delegate.getHeaderOctets();
        }

        public Long getTextualLineCount() {
            return this.delegate.getTextualLineCount();
        }

        public InputStream getHeaderContent() throws IOException {
            return this.delegate.getHeaderContent();
        }

        public InputStream getFullContent() throws IOException {
            return this.delegate.getFullContent();
        }

        public ThreadId getThreadId() {
            return this.delegate.getThreadId();
        }

        public Properties getProperties() {
            return this.delegate.getProperties();
        }

        public List<MessageAttachmentMetadata> getAttachments() {
            return this.delegate.getAttachments();
        }

        public Optional<Date> getSaveDate() {
            return this.delegate.getSaveDate();
        }

        public BlobId getHeaderBlobId() {
            return this.headerBlobId;
        }

        public MailboxMessage copy(Mailbox mailbox) throws MailboxException {
            return new CassandraMailboxMessage(this.delegate.copy(mailbox), this.headerBlobId);
        }
    }

    public static class Builder {
        private ComposedMessageIdWithMetaData composedMessageId;
        private Optional<Date> internalDate = Optional.empty();
        private Optional<Date> saveDate = Optional.empty();
        private Optional<Long> bodyStartOctet;
        private Optional<Long> size = Optional.empty();
        private Optional<BlobId> headerContent = Optional.empty();

        public Builder() {
            this.bodyStartOctet = Optional.empty();
        }

        public Builder ids(ComposedMessageIdWithMetaData ids) {
            this.composedMessageId = ids;
            return this;
        }

        public Builder internalDate(Date date) {
            this.internalDate = Optional.ofNullable(date);
            return this;
        }

        public Builder internalDate(Optional<Date> date) {
            this.internalDate = date;
            return this;
        }

        public Builder saveDate(Date date) {
            this.saveDate = Optional.ofNullable(date);
            return this;
        }

        public Builder saveDate(Optional<Date> date) {
            this.saveDate = date;
            return this;
        }

        public Builder bodyStartOctet(Long bodyStartOctet) {
            this.bodyStartOctet = Optional.ofNullable(bodyStartOctet);
            return this;
        }

        public Builder bodyStartOctet(Integer bodyStartOctet) {
            this.bodyStartOctet = Optional.ofNullable(bodyStartOctet).map(Integer::longValue);
            return this;
        }

        public Builder bodyStartOctet(Optional<Long> bodyStartOctet) {
            this.bodyStartOctet = bodyStartOctet;
            return this;
        }

        public Builder size(Long size) {
            this.size = Optional.ofNullable(size);
            return this;
        }

        public Builder size(Optional<Long> size) {
            this.size = size;
            return this;
        }

        public Builder headerContent(Optional<BlobId> headerContent) {
            this.headerContent = headerContent;
            return this;
        }

        public CassandraMessageMetadata build() {
            Preconditions.checkState((this.composedMessageId != null ? 1 : 0) != 0, (Object)"'composedMessageId' is compulsory");
            return new CassandraMessageMetadata(this.composedMessageId, this.internalDate, this.saveDate, this.bodyStartOctet, this.size, this.headerContent);
        }
    }
}

