/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.crypto;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.jmap.api.access.AccessToken;
import org.apache.james.jmap.api.access.AccessTokenRepository;
import org.apache.james.jmap.api.access.exceptions.InvalidAccessToken;
import org.apache.james.jmap.draft.api.AccessTokenManager;
import reactor.core.publisher.Mono;

public class AccessTokenManagerImpl
implements AccessTokenManager {
    private final AccessTokenRepository accessTokenRepository;

    @Inject
    AccessTokenManagerImpl(AccessTokenRepository accessTokenRepository) {
        this.accessTokenRepository = accessTokenRepository;
    }

    public Mono<AccessToken> grantAccessToken(Username username) {
        Preconditions.checkNotNull((Object)username);
        AccessToken accessToken = AccessToken.generate();
        return this.accessTokenRepository.addToken(username, accessToken).thenReturn((Object)accessToken);
    }

    public Mono<Username> getUsernameFromToken(AccessToken token) throws InvalidAccessToken {
        return this.accessTokenRepository.getUsernameFromToken(token);
    }

    public Mono<Boolean> isValid(AccessToken token) throws InvalidAccessToken {
        try {
            return this.getUsernameFromToken(token).thenReturn((Object)true);
        }
        catch (InvalidAccessToken e) {
            return Mono.just((Object)false);
        }
    }

    public Mono<Void> revoke(AccessToken token) {
        return this.accessTokenRepository.removeToken(token);
    }
}

