/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.service;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.fge.lambdas.Throwing;
import java.util.Optional;
import org.apache.james.core.MailAddress;
import org.apache.james.json.DTOModule;
import org.apache.james.queue.api.MailQueueFactory;
import org.apache.james.queue.api.MailQueueName;
import org.apache.james.queue.api.ManageableMailQueue;
import org.apache.james.server.task.json.dto.TaskDTO;
import org.apache.james.server.task.json.dto.TaskDTOModule;
import org.apache.james.webadmin.service.DeleteMailsFromMailQueueTask;

public class DeleteMailsFromMailQueueTaskDTO
implements TaskDTO {
    private final String type;
    private final String queueName;
    private final Optional<String> sender;
    private final Optional<String> name;
    private final Optional<String> recipient;

    public static TaskDTOModule<DeleteMailsFromMailQueueTask, DeleteMailsFromMailQueueTaskDTO> module(MailQueueFactory<? extends ManageableMailQueue> mailQueueFactory) {
        return (TaskDTOModule)DTOModule.forDomainObject(DeleteMailsFromMailQueueTask.class).convertToDTO(DeleteMailsFromMailQueueTaskDTO.class).toDomainObjectConverter(dto -> dto.fromDTO(mailQueueFactory)).toDTOConverter(DeleteMailsFromMailQueueTaskDTO::toDTO).typeName(DeleteMailsFromMailQueueTask.TYPE.asString()).withFactory(TaskDTOModule::new);
    }

    public static DeleteMailsFromMailQueueTaskDTO toDTO(DeleteMailsFromMailQueueTask domainObject, String typeName) {
        return new DeleteMailsFromMailQueueTaskDTO(typeName, domainObject.getQueueName().asString(), domainObject.getMaybeSender().map(MailAddress::asString), domainObject.getMaybeName(), domainObject.getMaybeRecipient().map(MailAddress::asString));
    }

    public DeleteMailsFromMailQueueTaskDTO(@JsonProperty(value="type") String type, @JsonProperty(value="queue") String queueName, @JsonProperty(value="sender") Optional<String> sender, @JsonProperty(value="name") Optional<String> name, @JsonProperty(value="recipient") Optional<String> recipient) {
        this.type = type;
        this.queueName = queueName;
        this.sender = sender;
        this.name = name;
        this.recipient = recipient;
    }

    public DeleteMailsFromMailQueueTask fromDTO(MailQueueFactory<? extends ManageableMailQueue> mailQueueFactory) {
        return new DeleteMailsFromMailQueueTask(MailQueueName.of((String)this.queueName), name -> (ManageableMailQueue)mailQueueFactory.getQueue(name).orElseThrow(() -> new DeleteMailsFromMailQueueTask.UnknownSerializedQueue(this.queueName)), this.sender.map(Throwing.function(MailAddress::new).sneakyThrow()), this.name, this.recipient.map(Throwing.function(MailAddress::new).sneakyThrow()));
    }

    public String getType() {
        return this.type;
    }

    public String getQueue() {
        return this.queueName;
    }

    public Optional<String> getSender() {
        return this.sender;
    }

    public Optional<String> getName() {
        return this.name;
    }

    public Optional<String> getRecipient() {
        return this.recipient;
    }
}

