/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.encode;

import java.io.IOException;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.encode.ImapResponseComposer;
import org.apache.james.imap.encode.ImapResponseEncoder;
import org.apache.james.imap.message.response.MyRightsResponse;
import org.apache.james.mailbox.model.MailboxACL;

public class MyRightsResponseEncoder
implements ImapResponseEncoder<MyRightsResponse> {
    @Override
    public Class<MyRightsResponse> acceptableMessages() {
        return MyRightsResponse.class;
    }

    @Override
    public void encode(MyRightsResponse aclResponse, ImapResponseComposer composer) throws IOException {
        MailboxACL.Rfc4314Rights myRights = aclResponse.getMyRights();
        composer.untagged();
        composer.commandName(ImapConstants.MYRIGHTS_COMMAND);
        String mailboxName = aclResponse.getMailboxName();
        composer.mailbox(mailboxName == null ? "" : mailboxName);
        composer.quote(myRights == null ? "" : myRights.serialize());
        composer.end();
    }
}

