/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.api;

import java.io.Closeable;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import javax.mail.MessagingException;
import org.apache.james.queue.api.MailQueueName;
import org.apache.mailet.Mail;
import org.reactivestreams.Publisher;
import org.threeten.extra.Temporals;

public interface MailQueue
extends Closeable {
    public static final String ENQUEUED_METRIC_NAME_PREFIX = "enqueuedMail:";
    public static final String DEQUEUED_METRIC_NAME_PREFIX = "dequeuedMail:";
    public static final String ENQUEUED_TIMER_METRIC_NAME_PREFIX = "enqueueTime:";
    public static final String QUEUE_SIZE_METRIC_NAME_PREFIX = "mailQueueSize:";
    public static final int NO_DELAY = -1;

    public MailQueueName getName();

    public void enQueue(Mail var1, Duration var2) throws MailQueueException;

    default public void enQueue(Mail mail, long delay, TimeUnit unit) throws MailQueueException {
        this.enQueue(mail, Temporals.chronoUnit((TimeUnit)unit).getDuration().multipliedBy(delay));
    }

    public void enQueue(Mail var1) throws MailQueueException;

    public Publisher<Void> enqueueReactive(Mail var1);

    public Publisher<MailQueueItem> deQueue();

    public static interface MailQueueItem {
        public Mail getMail();

        public void done(CompletionStatus var1) throws MailQueueException;

        public static enum CompletionStatus {
            SUCCESS,
            RETRY,
            REJECT;

        }
    }

    public static class MailQueueException
    extends MessagingException {
        public MailQueueException(String msg, Exception e) {
            super(msg, e);
        }

        public MailQueueException(String msg) {
            super(msg);
        }
    }
}

